/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.event;

import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.common.event.TempEffectsCommon;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.util.math.CSMath;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.CanPlayerSleepEvent;

@EventBusSubscriber
public class PreventPlayerSleep {
    @SubscribeEvent
    public static void onTrySleep(CanPlayerSleepEvent event) {
        ServerPlayer player = event.getEntity();
        if (event.getProblem() != null || !ConfigSettings.CHECK_SLEEP_CONDITIONS.get().booleanValue() || ConfigSettings.SLEEP_CHECK_IGNORE_BLOCKS.get().contains(player.level().getBlockState(event.getPos()).getBlock())) {
            return;
        }
        double bodyTemp = Temperature.get((LivingEntity)player, Temperature.Trait.BODY);
        double worldTemp = Temperature.get((LivingEntity)player, Temperature.Trait.WORLD);
        double minTemp = Temperature.get((LivingEntity)player, Temperature.Trait.FREEZING_POINT);
        double maxTemp = Temperature.get((LivingEntity)player, Temperature.Trait.BURNING_POINT);
        if (!CSMath.betweenExclusive(bodyTemp, -100.0, 100.0)) {
            Temperature.Trait trait = bodyTemp > 0.0 ? Temperature.Trait.HEAT_RESISTANCE : Temperature.Trait.COLD_RESISTANCE;
            if (Temperature.get((LivingEntity)player, trait) >= 1.0) {
                return;
            }
            player.displayClientMessage((Component)Component.translatable((String)("cold_sweat.message.sleep.body." + (bodyTemp > 99.0 ? "hot" : "cold"))), true);
            event.setProblem(Player.BedSleepingProblem.OTHER_PROBLEM);
        } else if (!CSMath.betweenExclusive(worldTemp, minTemp, maxTemp)) {
            if (TempEffectsCommon.getTempResistance((Player)event.getEntity(), minTemp > worldTemp) >= 4) {
                return;
            }
            player.displayClientMessage((Component)Component.translatable((String)("cold_sweat.message.sleep.world." + (worldTemp > maxTemp ? "hot" : "cold"))), true);
            event.setProblem(Player.BedSleepingProblem.OTHER_PROBLEM);
        }
    }
}

