/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.event;

import com.momosoftworks.coldsweat.api.event.vanilla.EntityPickEvent;
import com.momosoftworks.coldsweat.core.init.ModItems;
import com.momosoftworks.coldsweat.util.serialization.RegistryHelper;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

@EventBusSubscriber
public class ItemFrameEvents {
    @SubscribeEvent
    public static void onPickItem(EntityPickEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof ItemFrame) {
            ItemFrame frame = (ItemFrame)entity;
            if (event.getStack().getItem() == ModItems.THERMOMETER.value()) {
                ItemStack stack = frame.getItem().copy();
                if (frame.getPersistentData().contains("ItemName")) {
                    stack.set(DataComponents.CUSTOM_NAME, (Object)Component.Serializer.fromJson((String)frame.getPersistentData().getString("ItemName"), (HolderLookup.Provider)RegistryHelper.getRegistryAccess()));
                } else {
                    stack.remove(DataComponents.CUSTOM_NAME);
                }
                event.setStack(stack);
            }
        }
    }

    @SubscribeEvent
    public static void onThermometerPlaced(PlayerInteractEvent.EntityInteract event) {
        ItemFrame frame;
        Entity entity = event.getTarget();
        if (entity instanceof ItemFrame && (frame = (ItemFrame)entity).getItem().isEmpty() && event.getItemStack().getItem() == ModItems.THERMOMETER.value()) {
            if (event.getItemStack().has(DataComponents.CUSTOM_NAME)) {
                frame.getPersistentData().putString("ItemName", Component.Serializer.toJson((Component)event.getItemStack().getHoverName(), (HolderLookup.Provider)RegistryHelper.getRegistryAccess()));
            } else {
                frame.getPersistentData().remove("ItemName");
            }
        }
    }

    @SubscribeEvent
    public static void onItemFrameLoaded(PlayerEvent.StartTracking event) {
        Entity entity = event.getTarget();
        if (entity instanceof ItemFrame) {
            ItemFrame frame = (ItemFrame)entity;
            entity = event.getEntity();
            if (entity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                if (frame.getItem().getItem() == ModItems.THERMOMETER.value() && !frame.level().isClientSide && frame.getPersistentData().contains("ItemName")) {
                    WorldHelper.syncEntityForgeData((Entity)frame, player);
                }
            }
        }
    }
}

