/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.container;

import com.momosoftworks.coldsweat.api.event.common.insulation.InsulateItemEvent;
import com.momosoftworks.coldsweat.common.capability.handler.ItemInsulationManager;
import com.momosoftworks.coldsweat.common.capability.insulation.ItemInsulationCap;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.core.advancement.trigger.ArmorInsulatedTrigger;
import com.momosoftworks.coldsweat.core.init.ModAdvancementTriggers;
import com.momosoftworks.coldsweat.core.init.ModBlocks;
import com.momosoftworks.coldsweat.core.init.ModItemComponents;
import com.momosoftworks.coldsweat.core.init.ModMenus;
import com.momosoftworks.coldsweat.util.item.ItemStackHelper;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.ItemCombinerMenu;
import net.minecraft.world.inventory.ItemCombinerMenuSlotDefinition;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.Tags;
import org.jetbrains.annotations.Nullable;

public class SewingContainer
extends ItemCombinerMenu {
    protected boolean quickMoving = false;
    protected Inventory playerInventory;

    public SewingContainer(int containerId, Inventory inventory) {
        this((MenuType)ModMenus.SEWING_CONTAINER_TYPE.get(), containerId, inventory, ContainerLevelAccess.NULL);
    }

    public SewingContainer(int i, Inventory inventory, FriendlyByteBuf friendlyByteBuf) {
        this(i, inventory);
    }

    public SewingContainer(@Nullable MenuType<?> menuType, int containerId, Inventory inventory, ContainerLevelAccess chunkAccess) {
        super(menuType, containerId, inventory, chunkAccess);
        this.playerInventory = inventory;
    }

    protected ItemCombinerMenuSlotDefinition createInputSlotDefinitions() {
        return ItemCombinerMenuSlotDefinition.create().withSlot(0, 43, 26, stack -> stack.getItem() instanceof Equipable && !ConfigSettings.INSULATION_BLACKLIST.get().contains(stack.getItem()) && ConfigSettings.INSULATION_ITEMS.get().get((Object)stack.getItem()).isEmpty()).withSlot(1, 43, 53, stack -> !ConfigSettings.INSULATION_ITEMS.get().get((Object)stack.getItem()).isEmpty() || stack.is(Tags.Items.TOOLS_SHEAR)).withResultSlot(2, 121, 39).build();
    }

    public ItemStack getItem(int index) {
        return this.getContainerForSlot(index).getItem(index);
    }

    public void setItem(int index, ItemStack stack) {
        this.getContainerForSlot(index).setItem(index, stack);
    }

    protected Container getContainerForSlot(int index) {
        return index == this.getResultSlot() ? this.resultSlots : this.inputSlots;
    }

    public void growItem(int index, int amount) {
        ItemStack stack = this.getItem(index);
        stack.grow(amount);
        this.setItem(index, stack);
    }

    protected boolean mayPickup(Player player, boolean hasStack) {
        return true;
    }

    protected void onTake(Player player, ItemStack stack) {
        ItemStack input1 = this.getItem(0);
        ItemStack input2 = this.getItem(1);
        if (this.isRemovingInsulation()) {
            ItemInsulationManager.getInsulationCap(input1).ifPresent(cap -> {
                if (!cap.getInsulation().isEmpty()) {
                    if (!player.getAbilities().instabuild && player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        input2.hurtAndBreak(1, (ServerLevel)serverPlayer.level(), serverPlayer, item -> {});
                    }
                    cap = cap.removeInsulationItem(cap.getInsulationItem(cap.getInsulation().size() - 1));
                    player.level().playSound(null, player.blockPosition(), SoundEvents.SHEEP_SHEAR, SoundSource.PLAYERS, 0.8f, 1.0f);
                }
                input1.set(ModItemComponents.ARMOR_INSULATION, cap);
            });
        } else if (ItemInsulationManager.isInsulatable(stack)) {
            if (!this.quickMoving) {
                this.growItem(0, -1);
                this.growItem(1, -1);
            }
            player.level().playSound(null, player.blockPosition(), (SoundEvent)SoundEvents.LLAMA_SWAG.value(), SoundSource.BLOCKS, 0.5f, 1.0f);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ((ArmorInsulatedTrigger)((Object)ModAdvancementTriggers.ARMOR_INSULATED.value())).trigger(serverPlayer, input1, input2);
            }
        }
        Item item = stack.getItem();
        if (item instanceof ArmorItem) {
            ArmorItem armor = (ArmorItem)item;
            SoundEvent equipSound = (SoundEvent)((ArmorMaterial)armor.getMaterial().value()).equipSound().value();
            player.level().playSound(null, player.blockPosition(), equipSound, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        this.createResult();
    }

    protected boolean isValidBlock(BlockState state) {
        return state.is(ModBlocks.SEWING_TABLE);
    }

    public void createResult() {
        block6: {
            ItemStack processed;
            ItemStack insulatorItem;
            ItemStack wearableItem;
            block8: {
                block7: {
                    if (this.quickMoving) {
                        return;
                    }
                    wearableItem = this.getItem(0);
                    insulatorItem = this.getItem(1);
                    if (wearableItem.isEmpty() || insulatorItem.isEmpty()) {
                        this.setItem(this.getResultSlot(), ItemStack.EMPTY);
                        return;
                    }
                    if (!ItemInsulationManager.isInsulatable(wearableItem)) break block6;
                    if (!this.isRemovingInsulation()) break block7;
                    ItemInsulationManager.getInsulationCap(wearableItem).ifPresent(cap -> {
                        if (!cap.getInsulation().isEmpty()) {
                            this.setItem(this.getResultSlot(), cap.getInsulationItem(cap.getInsulation().size() - 1).copy());
                        }
                    });
                    break block6;
                }
                if (ConfigSettings.INSULATION_ITEMS.get().get((Object)insulatorItem.getItem()).isEmpty()) break block6;
                Item item = insulatorItem.getItem();
                if (!(item instanceof Equipable)) break block8;
                Equipable otherArmor = (Equipable)item;
                if (wearableItem.getEquipmentSlot() != otherArmor.getEquipmentSlot()) break block6;
            }
            if (this.insulateArmorItem(processed = wearableItem.copy(), insulatorItem)) {
                this.setItem(this.getResultSlot(), processed);
            }
        }
    }

    private boolean insulateArmorItem(ItemStack armorItem, ItemStack insulatorItem) {
        if (!ItemInsulationManager.isInsulatable(armorItem)) {
            return false;
        }
        InsulateItemEvent insulateEvent = new InsulateItemEvent(armorItem, insulatorItem, this.player);
        NeoForge.EVENT_BUS.post((Event)insulateEvent);
        if (insulateEvent.isCanceled()) {
            return false;
        }
        insulatorItem = insulateEvent.getInsulator();
        Optional<ItemInsulationCap> insulCap = ItemInsulationManager.getInsulationCap(armorItem);
        if (insulCap.isEmpty()) {
            return false;
        }
        ItemInsulationCap cap = insulCap.get();
        ItemStack insulator = insulatorItem.copy();
        insulator.setCount(1);
        if (!cap.canAddInsulationItem(armorItem, insulator)) {
            return false;
        }
        cap = cap.addInsulationItem(insulator);
        if (armorItem.has(DataComponents.ENCHANTMENTS) && insulator.has(DataComponents.ENCHANTMENTS)) {
            ItemEnchantments.Mutable insulatorEnch = new ItemEnchantments.Mutable(ItemStackHelper.getOrCreateComponent(insulator, DataComponents.ENCHANTMENTS, () -> ItemEnchantments.EMPTY));
            insulatorEnch.removeIf(ench -> {
                if (ench == null) {
                    return false;
                }
                if (armorItem.supportsEnchantment(ench) && ItemStackHelper.canApplyEnchantment(armorItem, (Holder<Enchantment>)ench)) {
                    armorItem.enchant(ench, insulatorEnch.getLevel(ench));
                    return true;
                }
                return false;
            });
        }
        armorItem.set(ModItemComponents.ARMOR_INSULATION, (Object)cap);
        return true;
    }

    public boolean isRemovingInsulation() {
        return this.getItem(1).is(Tags.Items.TOOLS_SHEAR);
    }

    public void removed(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            for (int i = 0; i < this.inputSlots.getContainerSize(); ++i) {
                ItemStack itemStack = this.getSlot(i).getItem();
                if (itemStack.isEmpty()) continue;
                if (player.isAlive() && !serverPlayer.hasDisconnected()) {
                    player.getInventory().placeItemBackInInventory(itemStack);
                    continue;
                }
                player.drop(itemStack, true);
            }
        }
        super.removed(player);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemStack quickMoveStack(Player player, int index) {
        try {
            if (index == this.getResultSlot() && !this.isRemovingInsulation()) {
                this.quickMoving = true;
                Slot resultSlot = (Slot)this.slots.get(index);
                ItemStack result = resultSlot.getItem();
                if (result.isEmpty()) {
                    ItemStack itemStack = result;
                    return itemStack;
                }
                do {
                    this.growItem(0, -1);
                    this.growItem(1, -1);
                } while (this.insulateArmorItem(result, this.getItem(1)));
            }
        }
        finally {
            this.quickMoving = false;
        }
        return super.quickMoveStack(player, index);
    }
}

