/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.command.argument;

import com.google.gson.JsonObject;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.momosoftworks.coldsweat.api.registry.TempModifierRegistry;
import java.util.Collection;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public class TempModifierArgument
implements ArgumentType<ResourceLocation> {
    public static TempModifierArgument modifier() {
        return new TempModifierArgument();
    }

    public static ResourceLocation getModifier(CommandContext<CommandSourceStack> context, String argument) {
        return (ResourceLocation)context.getArgument(argument, ResourceLocation.class);
    }

    public ResourceLocation parse(StringReader stringReader) throws CommandSyntaxException {
        ResourceLocation location = ResourceLocation.read((StringReader)stringReader);
        if (location.getNamespace().equals("minecraft")) {
            location = ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)location.getPath());
        }
        return location;
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        Stream<String> ids = TempModifierRegistry.getEntries().keySet().stream().map(ResourceLocation::toString);
        String input = builder.getRemaining().toLowerCase(Locale.ROOT);
        ids.filter(id -> id.toLowerCase(Locale.ROOT).contains(input)).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    }

    public Collection<String> getExamples() {
        return super.getExamples();
    }

    public static class Info
    implements ArgumentTypeInfo<TempModifierArgument, Template> {
        public void serializeToNetwork(Template template, FriendlyByteBuf buffer) {
        }

        public Template deserializeFromNetwork(FriendlyByteBuf buffer) {
            return new Template();
        }

        public void serializeToJson(Template template, JsonObject json) {
        }

        public Template unpack(TempModifierArgument argument) {
            return new Template();
        }

        public final class Template
        implements ArgumentTypeInfo.Template<TempModifierArgument> {
            public TempModifierArgument instantiate(CommandBuildContext pContext) {
                return new TempModifierArgument();
            }

            public ArgumentTypeInfo<TempModifierArgument, ?> type() {
                return Info.this;
            }
        }
    }
}

