/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.capability.insulation;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.momosoftworks.coldsweat.api.insulation.AdaptiveInsulation;
import com.momosoftworks.coldsweat.api.insulation.Insulation;
import com.momosoftworks.coldsweat.common.capability.handler.ItemInsulationManager;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.data.codec.configuration.InsulatorData;
import com.momosoftworks.coldsweat.util.math.CSMath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;

public record ItemInsulationCap(List<Pair<ItemStack, List<InsulatorData>>> insulation) {
    public static final Codec<Pair<ItemStack, List<InsulatorData>>> ITEM_INSULATION_PAIR_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ItemStack.CODEC.fieldOf("item").forGetter(Pair::getFirst), (App)InsulatorData.CODEC.listOf().fieldOf("insulation").forGetter(Pair::getSecond)).apply((Applicative)instance, Pair::new));
    public static final Codec<ItemInsulationCap> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ITEM_INSULATION_PAIR_CODEC.listOf().fieldOf("insulation").forGetter(ItemInsulationCap::insulation)).apply((Applicative)instance, ItemInsulationCap::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemInsulationCap> STREAM_CODEC = StreamCodec.of((buf, insul) -> insul.serialize((RegistryFriendlyByteBuf)buf), buf -> ItemInsulationCap.deserialize(buf));

    public ItemInsulationCap() {
        this(new ArrayList<Pair<ItemStack, List<InsulatorData>>>());
    }

    public List<Pair<ItemStack, List<InsulatorData>>> getInsulation() {
        return ImmutableList.copyOf(this.insulation());
    }

    public List<InsulatorData> getInsulators() {
        return this.insulation.stream().map(Pair::getSecond).flatMap(Collection::stream).toList();
    }

    public ItemInsulationCap calcAdaptiveInsulation(double worldTemp, double minTemp, double maxTemp) {
        ArrayList<Pair<ItemStack, List<InsulatorData>>> insulation = new ArrayList<Pair<ItemStack, List<InsulatorData>>>(this.insulation());
        for (Pair<ItemStack, List<InsulatorData>> entry : insulation) {
            for (InsulatorData insulatorData : (List)entry.getSecond()) {
                List<Insulation> entryDataList = insulatorData.insulation();
                for (int i = 0; i < entryDataList.size(); ++i) {
                    Insulation entryInsul = entryDataList.get(i);
                    if (!(entryInsul instanceof AdaptiveInsulation)) continue;
                    AdaptiveInsulation insul = (AdaptiveInsulation)entryInsul;
                    double newFactor = AdaptiveInsulation.calculateChange(insul, worldTemp, minTemp, maxTemp);
                    insul.setFactor(newFactor);
                }
            }
        }
        return new ItemInsulationCap(insulation);
    }

    public ItemInsulationCap addInsulationItem(ItemStack stack) {
        ArrayList<Pair<ItemStack, List<InsulatorData>>> insulation = new ArrayList<Pair<ItemStack, List<InsulatorData>>>(this.insulation());
        List<InsulatorData> newInsulation = ConfigSettings.INSULATION_ITEMS.get().get((Object)stack.getItem()).stream().map(InsulatorData::copy).toList();
        if (!newInsulation.isEmpty()) {
            insulation.add((Pair<ItemStack, List<InsulatorData>>)Pair.of((Object)stack, newInsulation));
        }
        return new ItemInsulationCap(insulation);
    }

    public ItemInsulationCap removeInsulationItem(ItemStack stack) {
        ArrayList<Pair<ItemStack, List<InsulatorData>>> insulation = new ArrayList<Pair<ItemStack, List<InsulatorData>>>(this.insulation());
        Optional<Pair> toRemove = insulation.stream().filter(entry -> ((ItemStack)entry.getFirst()).equals(stack)).findFirst();
        toRemove.ifPresent(insulation::remove);
        return new ItemInsulationCap(insulation);
    }

    public ItemStack getInsulationItem(int index) {
        return (ItemStack)this.insulation().get(index).getFirst();
    }

    public boolean canAddInsulationItem(ItemStack armorItem, ItemStack insulationItem) {
        List<InsulatorData> insulation = ConfigSettings.INSULATION_ITEMS.get().get((Object)insulationItem.getItem()).stream().filter(insulator -> insulator.test(null, insulationItem)).toList();
        if (insulation.isEmpty()) {
            return false;
        }
        int appliedInsulators = 0;
        for (InsulatorData data : CSMath.append(insulation, this.getInsulators())) {
            if (data.fillSlots()) {
                appliedInsulators += Insulation.splitList(data.insulation()).size();
                continue;
            }
            ++appliedInsulators;
        }
        return (appliedInsulators = Math.max(1, appliedInsulators)) <= ItemInsulationManager.getInsulationSlots(armorItem);
    }

    public void serialize(RegistryFriendlyByteBuf buffer) {
        buffer.writeInt(this.insulation().size());
        for (int i = 0; i < this.insulation().size(); ++i) {
            Pair<ItemStack, List<InsulatorData>> entry = this.insulation().get(i);
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)((ItemStack)entry.getFirst()));
            Collection insulList = (Collection)entry.getSecond();
            buffer.writeCollection(insulList, InsulatorData.SIMPLE_STREAM_CODEC);
        }
    }

    public static ItemInsulationCap deserialize(RegistryFriendlyByteBuf buffer) {
        ArrayList<Pair<ItemStack, List<InsulatorData>>> insulation = new ArrayList<Pair<ItemStack, List<InsulatorData>>>();
        int size = buffer.readInt();
        for (int i = 0; i < size; ++i) {
            ItemStack stack = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
            List insulList = buffer.readList(InsulatorData.SIMPLE_STREAM_CODEC);
            insulation.add((Pair<ItemStack, List<InsulatorData>>)Pair.of((Object)stack, (Object)insulList));
        }
        return new ItemInsulationCap(insulation);
    }
}

