/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.capability.handler;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import com.momosoftworks.coldsweat.api.insulation.Insulation;
import com.momosoftworks.coldsweat.common.capability.insulation.ItemInsulationCap;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.core.init.ModItemComponents;
import com.momosoftworks.coldsweat.data.codec.configuration.InsulatorData;
import com.momosoftworks.coldsweat.data.codec.configuration.ItemInsulationSlotsData;
import com.momosoftworks.coldsweat.util.item.ItemStackHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerContainerEvent;

@EventBusSubscriber
public class ItemInsulationManager {
    public static Optional<ItemInsulationCap> getInsulationCap(ItemStack stack) {
        if (ItemInsulationManager.isInsulatable(stack) && !stack.has(ModItemComponents.ARMOR_INSULATION)) {
            stack.set(ModItemComponents.ARMOR_INSULATION, (Object)new ItemInsulationCap());
        }
        return Optional.ofNullable((ItemInsulationCap)stack.get(ModItemComponents.ARMOR_INSULATION));
    }

    @SubscribeEvent
    public static void handleInventoryOpen(PlayerContainerEvent event) {
        event.getEntity().getPersistentData().putBoolean("InventoryOpen", event instanceof PlayerContainerEvent.Open);
    }

    public static int getInsulationSlots(ItemStack stack) {
        if (ItemInsulationManager.isInsulatable(stack)) {
            Item item = stack.getItem();
            Optional slotOverride = ConfigSettings.INSULATION_SLOT_OVERRIDES.get().get((Object)item).stream().findFirst();
            if (slotOverride.isPresent() && ((ItemInsulationSlotsData)slotOverride.get()).test(stack)) {
                return ((ItemInsulationSlotsData)slotOverride.get()).slots();
            }
            return ConfigSettings.INSULATION_SLOTS.get().getSlots(((Equipable)item).getEquipmentSlot(), stack);
        }
        return 0;
    }

    public static boolean isInsulatable(ItemStack stack) {
        return stack.getItem() instanceof Equipable && ItemInsulationManager.getBuiltinInsulation(stack).isEmpty();
    }

    public static List<Insulation> getBuiltinInsulation(ItemStack stack) {
        return Stream.of(ConfigSettings.INSULATION_ITEMS.get().get((Object)stack.getItem()), ConfigSettings.INSULATING_ARMORS.get().get((Object)stack.getItem()), ConfigSettings.INSULATING_CURIOS.get().get((Object)stack.getItem())).flatMap(Collection::stream).map(InsulatorData::insulation).flatMap(Collection::stream).filter(ins -> !ins.isEmpty()).toList();
    }

    public static List<InsulatorData> getAllInsulatorsForStack(ItemStack stack) {
        if (stack.isEmpty()) {
            return new ArrayList<InsulatorData>();
        }
        ArrayList<InsulatorData> insulators = new ArrayList<InsulatorData>();
        if (ItemInsulationManager.isInsulatable(stack)) {
            ItemInsulationManager.getInsulationCap(stack).ifPresent(cap -> {
                for (Pair<ItemStack, List<InsulatorData>> pair : cap.getInsulation()) {
                    insulators.addAll(ConfigSettings.INSULATION_ITEMS.get().get((Object)((ItemStack)pair.getFirst()).getItem()));
                }
            });
        }
        insulators.addAll(ConfigSettings.INSULATION_ITEMS.get().get((Object)stack.getItem()));
        insulators.addAll(ConfigSettings.INSULATING_ARMORS.get().get((Object)stack.getItem()));
        insulators.addAll(ConfigSettings.INSULATING_CURIOS.get().get((Object)stack.getItem()));
        return insulators;
    }

    public static List<InsulatorData> getEffectiveAppliedInsulation(ItemStack armor, @Nullable LivingEntity entity) {
        return ((List)ItemInsulationManager.getInsulationCap(armor).map(ItemInsulationCap::getInsulation).orElse(new ArrayList())).stream().map(pair -> pair.mapSecond(insulators -> insulators.stream().filter(entry -> entry.test((Entity)entity, (ItemStack)pair.getFirst())).toList())).map(Pair::getSecond).flatMap(Collection::stream).toList();
    }

    public static List<InsulatorData> getAllEffectiveInsulation(ItemStack armor, @Nullable LivingEntity entity) {
        ArrayList<InsulatorData> insulation = new ArrayList<InsulatorData>(ItemInsulationManager.getEffectiveAppliedInsulation(armor, entity));
        insulation.addAll(ConfigSettings.INSULATING_ARMORS.get().get((Object)armor.getItem()).stream().filter(insulator -> insulator.test((Entity)entity, armor)).toList());
        return ImmutableList.copyOf(insulation);
    }

    public static List<AttributeModifier> getAppliedInsulationAttributes(ItemStack stack, Holder<Attribute> attribute, @Nullable AttributeModifier.Operation operation, @Nullable Entity owner) {
        ArrayList<AttributeModifier> modifiers = new ArrayList<AttributeModifier>();
        for (InsulatorData insulator : ItemInsulationManager.getAllInsulatorsForStack(stack)) {
            if (!insulator.test(owner, stack)) continue;
            modifiers.addAll(insulator.attributes().get(attribute).stream().filter(mod -> operation == null || mod.operation() == operation).toList());
        }
        return modifiers;
    }

    public static List<AttributeModifier> getAttributeModifiersForSlot(ItemStack stack, Holder<Attribute> attribute, EquipmentSlot slot, @Nullable AttributeModifier.Operation operation, @Nullable Entity owner) {
        ArrayList<AttributeModifier> modifiers = new ArrayList<AttributeModifier>((operation != null ? ItemStackHelper.getAttributeModifiers(stack, slot).filter(entry -> entry.attribute().equals((Object)Holder.direct((Object)attribute))).filter(entry -> entry.modifier().operation() == operation) : ItemStackHelper.getAttributeModifiers(stack, slot).filter(entry -> entry.attribute().equals((Object)Holder.direct((Object)attribute)))).map(ItemAttributeModifiers.Entry::modifier).toList());
        modifiers.addAll(ItemInsulationManager.getAppliedInsulationAttributes(stack, attribute, operation, owner));
        return modifiers;
    }

    public static List<AttributeModifier> getAttributeModifiersForSlot(ItemStack stack, Holder<Attribute> attribute, EquipmentSlot slot) {
        return ItemInsulationManager.getAttributeModifiersForSlot(stack, attribute, slot, null, null);
    }
}

