/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.block;

import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.core.init.ModBlocks;
import com.momosoftworks.coldsweat.data.tag.ModBlockTags;
import com.momosoftworks.coldsweat.data.tag.ModItemTags;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Position;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import org.jetbrains.annotations.Nullable;

@EventBusSubscriber
public class SoulStalkBlock
extends Block {
    public static final IntegerProperty AGE = BlockStateProperties.AGE_15;
    public static final EnumProperty<Section> SECTION = EnumProperty.create((String)"section", Section.class);
    protected static final VoxelShape SHAPE = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    protected static final VoxelShape SHAPE_BUD = Block.box((double)4.5, (double)0.0, (double)4.5, (double)11.5, (double)14.0, (double)11.5);
    public static final int MAX_HEIGHT = 6;
    public static final DispenseItemBehavior GROWABLE_DISPENSE_BEHAVIOR = new DefaultDispenseItemBehavior(){

        protected ItemStack execute(BlockSource source, ItemStack stack) {
            Position position;
            BlockPos pos;
            ServerLevel level = source.level();
            BlockState state = level.getBlockState(pos = BlockPos.containing((Position)(position = DispenserBlock.getDispensePosition((BlockSource)source))));
            if (state.is(ModBlocks.SOUL_STALK)) {
                stack.shrink(1);
                SoulStalkBlock.applyGrowingItem((Level)level, pos);
                return stack;
            }
            return super.execute(source, stack);
        }
    };

    public SoulStalkBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)AGE, (Comparable)Integer.valueOf(0))).setValue(SECTION, (Comparable)((Object)Section.BUD)));
    }

    public static BlockBehaviour.Properties getProperties() {
        return BlockBehaviour.Properties.of().sound(SoundType.BIG_DRIPLEAF).strength(0.0f, 0.5f).randomTicks().lightLevel(state -> ((Section)((Object)((Object)state.getValue(SECTION)))).hasFruit() ? 4 : 0).noOcclusion().noCollission();
    }

    public static Item.Properties getItemProperties() {
        return new Item.Properties();
    }

    @SubscribeEvent
    public static void registerDispenserBehaviors(ServerStartedEvent event) {
        for (Holder item : (HolderSet.Named)BuiltInRegistries.ITEM.getTag(ModItemTags.GROWS_SOUL_STALK).get()) {
            DispenserBlock.registerBehavior((ItemLike)((ItemLike)item.value()), (DispenseItemBehavior)GROWABLE_DISPENSE_BEHAVIOR);
        }
    }

    public static Section getRandomMidsection() {
        return Math.random() < 0.5 ? Section.MIDDLE_SPROUT : Section.MIDDLE;
    }

    public static int getRandomGrowth() {
        return new Random().nextInt(2, 4);
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        if (level.isEmptyBlock(pos.above())) {
            int baseY;
            int topY = SoulStalkBlock.getTopY((Level)level, pos);
            if (topY - (baseY = SoulStalkBlock.getBaseY((Level)level, pos)) + 1 >= 6) {
                return;
            }
            double minTemp = ConfigSettings.MIN_TEMP.get();
            double maxTemp = ConfigSettings.MAX_TEMP.get();
            double tempAtBase = WorldHelper.getRoughTemperatureAt((Level)level, pos.atY(baseY));
            if (rand.nextDouble() < 0.05 + CSMath.blend(0.0, 0.95, tempAtBase, minTemp, maxTemp) && CommonHooks.canCropGrow((Level)level, (BlockPos)pos, (BlockState)state, (boolean)true)) {
                SoulStalkBlock.grow((Level)level, pos, 1);
            }
        }
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult rayTraceResult) {
        ItemStack holding = player.getItemInHand(hand);
        if (!level.isClientSide && holding.is(ModItemTags.GROWS_SOUL_STALK)) {
            if (SoulStalkBlock.getHeight(level, pos) >= 6) {
                return super.useItemOn(stack, state, level, pos, player, hand, rayTraceResult);
            }
            boolean grew = SoulStalkBlock.applyGrowingItem(level, pos);
            if (!player.getAbilities().instabuild) {
                holding.shrink(1);
            }
            Vec3 centerPos = CSMath.getCenterPos(pos);
            player.swing(hand, true);
            if (grew) {
                WorldHelper.spawnParticleBatch(level, (ParticleOptions)ParticleTypes.SOUL, centerPos.x, centerPos.y, centerPos.z, 0.75, 0.75, 0.75, 5.0, 0.01);
                level.playSound(null, pos, SoundEvents.SWEET_BERRY_BUSH_PLACE, SoundSource.BLOCKS, 1.0f, 0.8f);
            } else {
                level.playSound(null, pos, SoundEvents.WEEPING_VINES_PLACE, SoundSource.BLOCKS, 0.6f, 1.5f);
            }
            return ItemInteractionResult.CONSUME;
        }
        return super.useItemOn(stack, state, level, pos, player, hand, rayTraceResult);
    }

    public static boolean applyGrowingItem(Level level, BlockPos pos) {
        int baseY;
        int topY = SoulStalkBlock.getTopY(level, pos);
        if (topY - (baseY = SoulStalkBlock.getBaseY(level, pos)) + 1 >= 6) {
            return false;
        }
        return SoulStalkBlock.grow(level, pos.atY(topY), SoulStalkBlock.getRandomGrowth());
    }

    public static boolean grow(Level level, BlockPos pos, int growth) {
        BlockState state = level.getBlockState(pos);
        BlockState defaultState = state.getBlock().defaultBlockState();
        int age = (Integer)state.getValue((Property)AGE) + growth;
        Section section = (Section)((Object)state.getValue(SECTION));
        if (age >= 4) {
            if (section == Section.TOP) {
                level.setBlockAndUpdate(pos, (BlockState)((BlockState)defaultState.setValue((Property)AGE, (Comparable)Integer.valueOf(0))).setValue(SECTION, (Comparable)((Object)SoulStalkBlock.getRandomMidsection())));
                level.setBlockAndUpdate(pos.above(), (BlockState)((BlockState)defaultState.setValue((Property)AGE, (Comparable)Integer.valueOf(0))).setValue(SECTION, (Comparable)((Object)Section.TOP)));
            } else if (section == Section.BUD) {
                level.setBlockAndUpdate(pos, (BlockState)((BlockState)defaultState.setValue((Property)AGE, (Comparable)Integer.valueOf(0))).setValue(SECTION, (Comparable)((Object)Section.BASE)));
                level.setBlockAndUpdate(pos.above(), (BlockState)((BlockState)defaultState.setValue((Property)AGE, (Comparable)Integer.valueOf(0))).setValue(SECTION, (Comparable)((Object)Section.TOP)));
            }
            return true;
        }
        level.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(age)), 2);
        return false;
    }

    public static int getHeight(Level level, BlockPos pos) {
        return SoulStalkBlock.getTopY(level, pos) - SoulStalkBlock.getBaseY(level, pos) + 1;
    }

    public static int getTopY(Level level, BlockPos pos) {
        int aboveHeight = 1;
        while (level.getBlockState(pos.above(aboveHeight)).is(ModBlocks.SOUL_STALK)) {
            ++aboveHeight;
        }
        return pos.getY() + aboveHeight - 1;
    }

    public static int getBaseY(Level level, BlockPos pos) {
        int belowHeight = 1;
        while (level.getBlockState(pos.below(belowHeight)).is(ModBlocks.SOUL_STALK)) {
            ++belowHeight;
        }
        return pos.getY() - belowHeight + 1;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos pos = context.getClickedPos();
        return context.getLevel().getBlockState(pos.below()).getBlock() == this ? (BlockState)this.defaultBlockState().setValue(SECTION, (Comparable)((Object)Section.TOP)) : (this.canSurvive(this.defaultBlockState(), (LevelReader)context.getLevel(), pos) ? this.defaultBlockState() : null);
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState otherState, LevelAccessor level, BlockPos pos, BlockPos otherPos) {
        if (!this.canSurvive(state, (LevelReader)level, pos)) {
            return Blocks.AIR.defaultBlockState();
        }
        if (direction == Direction.UP) {
            if (otherState.getBlock() != this) {
                return Blocks.AIR.defaultBlockState();
            }
            switch (((Section)((Object)state.getValue(SECTION))).ordinal()) {
                case 3: {
                    return (BlockState)state.setValue(SECTION, (Comparable)((Object)SoulStalkBlock.getRandomMidsection()));
                }
                case 4: {
                    return (BlockState)state.setValue(SECTION, (Comparable)((Object)Section.BASE));
                }
            }
        }
        return state;
    }

    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return state.getValue(SECTION) == Section.BUD ? SHAPE_BUD : SHAPE;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AGE, SECTION});
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockState below = level.getBlockState(pos.below());
        return below.is(ModBlockTags.SOUL_STALK_PLACEABLE_ON) || below.getBlock() == this;
    }

    public static enum Section implements StringRepresentable
    {
        BASE("base", false),
        MIDDLE("middle", false),
        MIDDLE_SPROUT("middle_sprout", true),
        TOP("top", true),
        BUD("bud", true);

        private final String name;
        private final boolean hasSprout;

        private Section(String name, boolean hasSprout) {
            this.name = name;
            this.hasSprout = hasSprout;
        }

        public boolean hasFruit() {
            return this.hasSprout;
        }

        public String getSerializedName() {
            return this.name;
        }
    }
}

