/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.block;

import com.momosoftworks.coldsweat.common.blockentity.HearthBlockEntity;
import com.momosoftworks.coldsweat.common.blockentity.IceboxBlockEntity;
import com.momosoftworks.coldsweat.core.init.ModBlockEntities;
import com.momosoftworks.coldsweat.core.init.ModBlocks;
import com.momosoftworks.coldsweat.core.init.ModItems;
import com.momosoftworks.coldsweat.core.init.ModParticleTypes;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.ParticleStatus;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class IceboxBlock
extends Block
implements EntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty FROSTED = BooleanProperty.create((String)"frosted");
    public static final BooleanProperty SMOKESTACK = BooleanProperty.create((String)"smokestack");
    public static final VoxelShape SHAPE = Shapes.block();
    private static final VoxelShape SHAPE_OPEN = Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.8125, (double)1.0);

    public static BlockBehaviour.Properties getProperties() {
        return BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.0f, 5.0f).isRedstoneConductor(IceboxBlock::conductsRedstone).noOcclusion();
    }

    public static Item.Properties getItemProperties() {
        return new Item.Properties();
    }

    private static boolean conductsRedstone(BlockState state, BlockGetter level, BlockPos pos) {
        BlockEntity be = level.getBlockEntity(pos);
        if (be instanceof HearthBlockEntity) {
            HearthBlockEntity hearthLike = (HearthBlockEntity)be;
            return !hearthLike.hasSmokeStack();
        }
        return false;
    }

    public IceboxBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)FROSTED, (Comparable)Boolean.valueOf(false))).setValue((Property)SMOKESTACK, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return type == ModBlockEntities.ICEBOX.value() ? IceboxBlockEntity::tick : null;
    }

    public RenderShape getRenderShape(BlockState pState) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext selection) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof IceboxBlockEntity) {
            IceboxBlockEntity icebox = (IceboxBlockEntity)blockEntity;
            return icebox.getOpenNess(0.0f) > 0.0f ? SHAPE_OPEN : SHAPE;
        }
        return SHAPE;
    }

    public boolean triggerEvent(BlockState state, Level level, BlockPos pos, int id, int param) {
        BlockEntity blockentity = level.getBlockEntity(pos);
        return blockentity != null && blockentity.triggerEvent(id, param);
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult rayTraceResult) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof IceboxBlockEntity) {
            IceboxBlockEntity icebox = (IceboxBlockEntity)blockEntity;
            if (stack.getItem() == ModItems.SMOKESTACK.value() && rayTraceResult.getDirection() == Direction.UP && level.getBlockState(pos.above()).canBeReplaced()) {
                return ItemInteractionResult.FAIL;
            }
            int itemFuel = icebox.getItemFuel(stack);
            if (itemFuel != 0 && (double)icebox.getFuel() + (double)itemFuel * 0.75 < (double)icebox.getMaxFuel()) {
                if (!player.isCreative()) {
                    if (stack.hasCraftingRemainingItem()) {
                        ItemStack container = stack.getCraftingRemainingItem();
                        stack.shrink(1);
                        player.getInventory().add(container);
                    } else {
                        stack.shrink(1);
                    }
                }
                icebox.setFuel(icebox.getFuel() + itemFuel);
                level.playSound(null, pos, SoundEvents.BUCKET_EMPTY, SoundSource.BLOCKS, 1.0f, 0.9f + new Random().nextFloat() * 0.2f);
            } else if (!level.isClientSide && !ChestBlock.isChestBlockedAt((LevelAccessor)level, (BlockPos)pos)) {
                player.openMenu((MenuProvider)icebox, pos);
            }
        }
        return ItemInteractionResult.SUCCESS;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new IceboxBlockEntity(pos, state);
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        boolean hasSmokeStack;
        IceboxBlockEntity icebox;
        boolean hadSmokestack;
        BlockEntity blockEntity;
        if (neighborPos.equals((Object)pos.above()) && (blockEntity = level.getBlockEntity(pos)) instanceof IceboxBlockEntity && (hadSmokestack = (icebox = (IceboxBlockEntity)blockEntity).hasSmokeStack()) != (hasSmokeStack = icebox.checkForSmokestack())) {
            state = (BlockState)state.setValue((Property)SMOKESTACK, (Comparable)Boolean.valueOf(hasSmokeStack));
            level.setBlock(pos, state, 3);
            level.blockUpdated(pos, (Block)this);
        }
        return super.updateShape(state, direction, neighborState, level, pos, neighborPos);
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos fromPos, boolean isMoving) {
        super.neighborChanged(state, level, pos, neighborBlock, fromPos, isMoving);
        HearthBlockEntity hearth = (HearthBlockEntity)level.getBlockEntity(pos);
        if (hearth != null) {
            hearth.checkInputSignal();
        }
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity tileentity;
        if (state.getBlock() != newState.getBlock() && (tileentity = world.getBlockEntity(pos)) instanceof IceboxBlockEntity) {
            IceboxBlockEntity te = (IceboxBlockEntity)tileentity;
            Containers.dropContents((Level)world, (BlockPos)pos, (Container)te);
            world.updateNeighborsAt(pos, (Block)this);
        }
        super.onRemove(state, world, pos, newState, isMoving);
    }

    public BlockState rotate(BlockState state, Rotation direction) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)direction.rotate((Direction)state.getValue((Property)FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, FROSTED, SMOKESTACK});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource rand) {
        ParticleStatus status = (ParticleStatus)Minecraft.getInstance().options.particles().get();
        if (!((Boolean)state.getValue((Property)FROSTED)).booleanValue() || status == ParticleStatus.MINIMAL) {
            return;
        }
        double d0 = (double)pos.getX() + 0.5;
        double d1 = pos.getY();
        double d2 = (double)pos.getZ() + 0.5;
        boolean side = new Random().nextBoolean();
        double d5 = side ? Math.random() - 0.5 : (Math.random() < 0.5 ? 0.55 : -0.55);
        double d6 = Math.random() * 0.3;
        double d7 = !side ? Math.random() - 0.5 : (Math.random() < 0.5 ? 0.55 : -0.55);
        level.addParticle((ParticleOptions)ModParticleTypes.GROUND_MIST.get(), d0 + d5, d1 + d6, d2 + d7, d5 / 40.0, 0.0, d7 / 40.0);
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter level, BlockPos pos, @Nullable Direction direction) {
        return direction != null && direction.getAxis() != Direction.Axis.Y && level.getBlockState(pos.above()).is(ModBlocks.SMOKESTACK);
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        return AbstractContainerMenu.getRedstoneSignalFromBlockEntity((BlockEntity)level.getBlockEntity(pos));
    }
}

