/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.client.renderer.layer;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.momosoftworks.coldsweat.api.insulation.AdaptiveInsulation;
import com.momosoftworks.coldsweat.common.item.ChameleonArmorItem;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ChameleonArmorLayer<T extends LivingEntity, M extends HumanoidModel<T>, A extends HumanoidModel<T>>
extends HumanoidArmorLayer<T, M, A> {
    public static final ResourceLocation GREEN_LAYER_1_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"textures/models/armor/chameleon_layer_1.png");
    public static final ResourceLocation GREEN_LAYER_2_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"textures/models/armor/chameleon_layer_2.png");
    public static final ResourceLocation RED_LAYER_1_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"textures/models/armor/chameleon_layer_1_red.png");
    public static final ResourceLocation RED_LAYER_2_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"textures/models/armor/chameleon_layer_2_red.png");
    public static final ResourceLocation BLUE_LAYER_1_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"textures/models/armor/chameleon_layer_1_blue.png");
    public static final ResourceLocation BLUE_LAYER_2_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"textures/models/armor/chameleon_layer_2_blue.png");

    public ChameleonArmorLayer(RenderLayerParent<T, M> renderer, ModelManager modelManager) {
        super(renderer, null, null, modelManager);
    }

    public void render(PoseStack poseStack, MultiBufferSource buffer, int light, T entity, float pLimbSwing, float pLimbSwingAmount, float pPartialTicks, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        this.renderArmorPiece(poseStack, buffer, entity, EquipmentSlot.CHEST, light);
        this.renderArmorPiece(poseStack, buffer, entity, EquipmentSlot.LEGS, light);
        this.renderArmorPiece(poseStack, buffer, entity, EquipmentSlot.FEET, light);
        this.renderArmorPiece(poseStack, buffer, entity, EquipmentSlot.HEAD, light);
    }

    protected void renderArmorPiece(PoseStack poseStack, MultiBufferSource buffer, T livingEntity, EquipmentSlot slot, int light) {
        ChameleonArmorItem armorItem;
        ItemStack itemstack = livingEntity.getItemBySlot(slot);
        Item item = itemstack.getItem();
        if (item instanceof ChameleonArmorItem && (armorItem = (ChameleonArmorItem)item).getEquipmentSlot() == slot) {
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            boolean isInnerModel = this.usesInnerModel(slot);
            HumanoidModel<?> model = ChameleonArmorItem.Client.getRealArmorModel(livingEntity, itemstack, slot);
            ((HumanoidModel)this.getParentModel()).copyPropertiesTo(model);
            this.setPartVisibilities(model, slot);
            this.renderModel(poseStack, buffer, light, armorItem, (Model)model, isInnerModel, 1.0f, 1.0f, 1.0f, 1.0f, Color.GREEN.getLayer(slot));
            double adaptiveFactor = AdaptiveInsulation.getFactorFromArmor(itemstack);
            ResourceLocation overlay = adaptiveFactor < 0.0 ? Color.BLUE.getLayer(slot) : Color.RED.getLayer(slot);
            float alpha = (float)Math.abs(adaptiveFactor);
            this.renderModel(poseStack, buffer, light, armorItem, (Model)model, isInnerModel, 1.0f, 1.0f, 1.0f, alpha, overlay);
            if (itemstack.hasFoil()) {
                this.renderGlint(poseStack, buffer, light, (Model)model);
            }
            RenderSystem.disableBlend();
        }
    }

    protected boolean usesInnerModel(EquipmentSlot slot) {
        return slot == EquipmentSlot.LEGS;
    }

    protected void renderModel(PoseStack poseStack, MultiBufferSource buffer, int light, ArmorItem armorItem, Model model, boolean showGlint, float red, float green, float blue, float alpha, ResourceLocation armorResource) {
        VertexConsumer vertexconsumer = buffer.getBuffer(RenderType.entityTranslucent((ResourceLocation)armorResource));
        model.renderToBuffer(poseStack, vertexconsumer, light, OverlayTexture.NO_OVERLAY, FastColor.ARGB32.colorFromFloat((float)alpha, (float)red, (float)green, (float)blue));
    }

    protected void renderGlint(PoseStack poseStack, MultiBufferSource buffer, int packedLight, Model model) {
        model.renderToBuffer(poseStack, buffer.getBuffer(RenderType.armorEntityGlint()), packedLight, OverlayTexture.NO_OVERLAY, FastColor.ARGB32.colorFromFloat((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f));
    }

    protected void setPartVisibilities(HumanoidModel<T> pModel, EquipmentSlot pSlot) {
        pModel.setAllVisible(false);
        switch (pSlot) {
            case HEAD: {
                pModel.head.visible = true;
                pModel.hat.visible = true;
                break;
            }
            case CHEST: {
                pModel.body.visible = true;
                pModel.rightArm.visible = true;
                pModel.leftArm.visible = true;
                break;
            }
            case LEGS: {
                pModel.body.visible = true;
                pModel.rightLeg.visible = true;
                pModel.leftLeg.visible = true;
                break;
            }
            case FEET: {
                pModel.rightLeg.visible = true;
                pModel.leftLeg.visible = true;
            }
        }
    }

    public static enum Color {
        GREEN(GREEN_LAYER_1_LOCATION, GREEN_LAYER_2_LOCATION),
        RED(RED_LAYER_1_LOCATION, RED_LAYER_2_LOCATION),
        BLUE(BLUE_LAYER_1_LOCATION, BLUE_LAYER_2_LOCATION);

        private final ResourceLocation layer1;
        private final ResourceLocation layer2;

        private Color(ResourceLocation layer1, ResourceLocation layer2) {
            this.layer1 = layer1;
            this.layer2 = layer2;
        }

        public ResourceLocation getLayer1() {
            return this.layer1;
        }

        public ResourceLocation getLayer2() {
            return this.layer2;
        }

        public ResourceLocation getLayer(EquipmentSlot slot) {
            return slot == EquipmentSlot.LEGS ? this.layer2 : this.layer1;
        }
    }
}

