/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.client.renderer.item;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.momosoftworks.coldsweat.common.item.SoulspringLampItem;
import com.momosoftworks.coldsweat.core.init.ModItems;
import com.momosoftworks.coldsweat.util.math.CSMath;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class SoulSpringLampRenderer
extends BlockEntityWithoutLevelRenderer {
    public static final ResourceLocation TEXTURE_FRAME = ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"textures/item/soulspring_lamp/render/soulspring_lamp_frame.png");
    public static final ResourceLocation TEXTURE_0 = ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"textures/item/soulspring_lamp/render/soulspring_lamp_0.png");
    public static final ResourceLocation TEXTURE_1 = ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"textures/item/soulspring_lamp/render/soulspring_lamp_1.png");
    public static final ResourceLocation TEXTURE_2 = ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"textures/item/soulspring_lamp/render/soulspring_lamp_2.png");
    public static final ResourceLocation TEXTURE_3 = ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"textures/item/soulspring_lamp/render/soulspring_lamp_3.png");
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"soulspring_lamp"), "main");
    private final ModelPart base;
    private final ModelPart heart;

    public SoulSpringLampRenderer(BlockEntityRenderDispatcher dispatcher, EntityModelSet modelSel) {
        super(dispatcher, modelSel);
        ModelPart root = modelSel.bakeLayer(LAYER_LOCATION);
        this.base = root.getChild("base");
        this.heart = root.getChild("heart");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition base = partdefinition.addOrReplaceChild("base", CubeListBuilder.create().texOffs(0, 11).addBox(-12.0f, -17.0f, 4.0f, 8.0f, 11.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(22, 21).addBox(-13.0f, -6.0f, 3.0f, 10.0f, 1.0f, 10.0f, new CubeDeformation(0.0f)).texOffs(58, 21).addBox(-9.5f, -5.0f, 8.0f, 3.0f, 8.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(52, 18).addBox(-8.0f, -5.0f, 6.5f, 0.0f, 8.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(24, 0).addBox(-13.0f, -19.0f, 3.0f, 10.0f, 3.0f, 10.0f, new CubeDeformation(0.0f)).texOffs(40, 13).addBox(-11.0f, -21.0f, 5.0f, 6.0f, 2.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(0, -7).addBox(-8.0f, -28.0f, 4.5f, 0.0f, 7.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)8.0f, (float)24.0f, (float)-8.0f));
        PartDefinition heart = partdefinition.addOrReplaceChild("heart", CubeListBuilder.create().texOffs(14, 0).addBox(-2.5f, -2.5f, -2.5f, 5.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public void renderByItem(ItemStack stack, ItemDisplayContext displayContext, PoseStack poseStack, MultiBufferSource buffer, int light, int overlay) {
        if (stack.is(ModItems.SOULSPRING_LAMP)) {
            Minecraft mc = Minecraft.getInstance();
            float time = mc.level != null ? (float)mc.level.getGameTime() + mc.getTimer().getGameTimeDeltaPartialTick(true) : 0.0f;
            boolean isFirstPerson = mc.options.getCameraType().isFirstPerson();
            double fuel = SoulspringLampItem.getFuel(stack);
            ResourceLocation texture = SoulSpringLampRenderer.getTexture(stack);
            if (fuel > 0.0) {
                this.heart.y = -14.0f + (float)Math.sin(time / 8.0f) * 1.2f;
                this.heart.xRot = CSMath.toRadians(time * 2.0f % 360.0f);
                this.heart.yRot = CSMath.toRadians((time * 2.0f + 10.0f) % 360.0f);
                this.heart.zRot = CSMath.toRadians(((double)time * 0.5 + 5.0) % 360.0);
            } else {
                this.heart.y = -14.0f;
                this.heart.yRot = 0.0f;
                this.heart.xRot = 0.0f;
                this.heart.zRot = 0.0f;
            }
            float emission = SoulspringLampItem.isLit(stack) ? (float)CSMath.blend(0.0, 1.0, fuel, 0.0, 64.0) : 0.0f;
            RenderSystem.enableBlend();
            RenderSystem.enableDepthTest();
            poseStack.pushPose();
            poseStack.translate(0.5, 1.5, 0.5);
            poseStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
            VertexConsumer frameVertexes = buffer.getBuffer(RenderType.entityTranslucent((ResourceLocation)TEXTURE_FRAME));
            this.base.render(poseStack, frameVertexes, light, overlay);
            poseStack.pushPose();
            double heartYOffset = isFirstPerson ? 1.65 : 1.55;
            float heartScale = isFirstPerson ? 0.925f : 0.9f;
            poseStack.translate(0.0, heartYOffset, 0.0);
            poseStack.scale(heartScale, heartScale, heartScale);
            VertexConsumer heartVtx = buffer.getBuffer(RenderType.entityTranslucent((ResourceLocation)texture));
            this.heart.render(poseStack, heartVtx, light, overlay, FastColor.ARGB32.colorFromFloat((float)(1.0f - emission), (float)1.0f, (float)1.0f, (float)1.0f));
            VertexConsumer heartVtxEmissive = buffer.getBuffer(RenderType.entityTranslucentEmissive((ResourceLocation)texture));
            this.heart.render(poseStack, heartVtxEmissive, light, overlay, FastColor.ARGB32.colorFromFloat((float)emission, (float)1.0f, (float)1.0f, (float)1.0f));
            poseStack.popPose();
            VertexConsumer glassVtx = buffer.getBuffer(RenderType.entityTranslucent((ResourceLocation)texture));
            this.base.render(poseStack, glassVtx, light, overlay, FastColor.ARGB32.colorFromFloat((float)(1.0f - emission), (float)1.0f, (float)1.0f, (float)1.0f));
            VertexConsumer glassVtxEmissive = buffer.getBuffer(RenderType.entityTranslucentEmissive((ResourceLocation)texture));
            this.base.render(poseStack, glassVtxEmissive, light, overlay, FastColor.ARGB32.colorFromFloat((float)emission, (float)1.0f, (float)1.0f, (float)1.0f));
            poseStack.popPose();
        } else {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            super.renderByItem(stack, displayContext, poseStack, buffer, light, overlay);
        }
    }

    private static ResourceLocation getTexture(ItemStack lamp) {
        double fuel = SoulspringLampItem.getFuel(lamp);
        int state = SoulspringLampItem.isLit(lamp) ? (fuel > 43.0 ? 3 : (fuel > 22.0 ? 2 : 1)) : 0;
        return switch (state) {
            case 1 -> TEXTURE_1;
            case 2 -> TEXTURE_2;
            case 3 -> TEXTURE_3;
            default -> TEXTURE_0;
        };
    }
}

