/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.client.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.momosoftworks.coldsweat.common.block.IceboxBlock;
import com.momosoftworks.coldsweat.common.blockentity.IceboxBlockEntity;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class IceboxBlockEntityRenderer
implements BlockEntityRenderer<IceboxBlockEntity> {
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"textures/block/icebox.png");
    public static final ResourceLocation TEXTURE_SMOKESTACK = ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"textures/block/icebox_smokestack.png");
    public static final ResourceLocation TEXTURE_FROST = ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"textures/block/icebox_frost.png");
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"icebox"), "main");
    ModelPart container;
    ModelPart lid;

    public IceboxBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        ModelPart base = context.bakeLayer(LAYER_LOCATION);
        this.container = base.getChild("container");
        this.lid = base.getChild("lid");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition lid = partdefinition.addOrReplaceChild("lid", CubeListBuilder.create().texOffs(0, 0).addBox(-8.0f, -3.0f, -16.0f, 16.0f, 3.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)11.0f, (float)8.0f));
        PartDefinition container = partdefinition.addOrReplaceChild("container", CubeListBuilder.create().texOffs(0, 19).addBox(-8.0f, -13.0f, -8.0f, 16.0f, 13.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)48);
    }

    public void render(IceboxBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int light, int overlay) {
        BlockState blockstate = blockEntity.getBlockState();
        poseStack.pushPose();
        float f = ((Direction)blockstate.getValue((Property)ChestBlock.FACING)).toYRot();
        poseStack.translate(0.5f, 0.5f, 0.5f);
        poseStack.mulPose(Axis.YP.rotationDegrees(-f));
        poseStack.mulPose(Axis.XP.rotationDegrees(180.0f));
        poseStack.translate(0.0f, -1.0f, 0.0f);
        VertexConsumer vertexes = buffer.getBuffer(RenderType.entityCutout((ResourceLocation)IceboxBlockEntityRenderer.getTexture(blockstate)));
        if (!blockEntity.hasSmokeStack()) {
            float openness = blockEntity.getOpenNess(partialTick);
            openness = 1.0f - openness;
            openness = 1.0f - (float)Math.pow(openness, 3.0);
            this.lid.xRot = -(openness * 1.5707964f) * 0.999f;
        } else {
            this.lid.xRot = 0.0f;
        }
        this.container.render(poseStack, vertexes, light, overlay);
        this.lid.render(poseStack, vertexes, light, overlay);
        if (((Boolean)blockstate.getValue((Property)IceboxBlock.FROSTED)).booleanValue()) {
            VertexConsumer frostedVertexes = buffer.getBuffer(RenderType.entityTranslucent((ResourceLocation)TEXTURE_FROST));
            this.container.render(poseStack, frostedVertexes, light, overlay);
        }
        poseStack.popPose();
    }

    public static ResourceLocation getTexture(BlockState state) {
        return (Boolean)state.getValue((Property)IceboxBlock.SMOKESTACK) != false ? TEXTURE_SMOKESTACK : TEXTURE;
    }
}

