/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.client.gui.config.pages;

import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.client.gui.Overlays;
import com.momosoftworks.coldsweat.client.gui.config.AbstractConfigPage;
import com.momosoftworks.coldsweat.client.gui.config.ConfigScreen;
import com.momosoftworks.coldsweat.client.gui.config.pages.ConfigPageDifficulty;
import com.momosoftworks.coldsweat.client.gui.config.pages.ConfigPageTempEffects;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;

public class ConfigPageOne
extends AbstractConfigPage {
    Screen parentScreen;

    public ConfigPageOne(Screen parentScreen) {
        super(parentScreen);
        if (parentScreen == null) {
            parentScreen = Minecraft.getInstance().screen;
        }
        this.parentScreen = parentScreen;
    }

    @Override
    public Component sectionOneTitle() {
        return Component.translatable((String)"cold_sweat.config.section.temperature_details");
    }

    @Override
    public Component sectionTwoTitle() {
        return Component.translatable((String)"cold_sweat.config.section.difficulty");
    }

    @Override
    protected void init() {
        super.init();
        Temperature.Units[] properUnits = new Temperature.Units[]{ConfigSettings.CELSIUS.get() != false ? Temperature.Units.C : Temperature.Units.F};
        this.addButton("units", AbstractConfigPage.Side.LEFT, () -> Component.translatable((String)"cold_sweat.config.units.name").append(": ").append((Component)(ConfigSettings.CELSIUS.get() != false ? Component.translatable((String)"cold_sweat.config.celsius.name") : Component.translatable((String)"cold_sweat.config.fahrenheit.name"))), button -> {
            LocalPlayer player = Minecraft.getInstance().player;
            ConfigSettings.CELSIUS.set(ConfigSettings.CELSIUS.get() == false);
            properUnits[0] = ConfigSettings.CELSIUS.get() != false ? Temperature.Units.C : Temperature.Units.F;
            ((EditBox)this.getWidgetBatch("max_temp").get(0)).setValue(String.valueOf(ConfigScreen.TWO_PLACES.format(Temperature.convert(ConfigSettings.MAX_TEMP.get(), Temperature.Units.MC, properUnits[0], true))));
            ((EditBox)this.getWidgetBatch("min_temp").get(0)).setValue(String.valueOf(ConfigScreen.TWO_PLACES.format(Temperature.convert(ConfigSettings.MIN_TEMP.get(), Temperature.Units.MC, properUnits[0], true))));
            if (player != null) {
                Overlays.setWorldTempInstant(Temperature.convert(Overlays.WORLD_TEMP, properUnits[0] == Temperature.Units.C ? Temperature.Units.F : Temperature.Units.C, properUnits[0], true));
            }
        }, false, false, true, new Component[]{Component.translatable((String)"cold_sweat.config.units.desc")});
        this.addDecimalInput("max_temp", AbstractConfigPage.Side.LEFT, (Component)Component.translatable((String)"cold_sweat.config.max_temperature.name"), value -> ConfigSettings.MAX_TEMP.set(Temperature.convert(value, properUnits[0], Temperature.Units.MC, true)), input -> input.setValue(String.valueOf(Temperature.convert(ConfigSettings.MAX_TEMP.get(), Temperature.Units.MC, properUnits[0], true))), true, false, false, new Component[]{Component.translatable((String)"cold_sweat.config.max_temperature.desc")});
        this.addDecimalInput("min_temp", AbstractConfigPage.Side.LEFT, (Component)Component.translatable((String)"cold_sweat.config.min_temperature.name"), value -> ConfigSettings.MIN_TEMP.set(Temperature.convert(value, properUnits[0], Temperature.Units.MC, true)), input -> input.setValue(String.valueOf(Temperature.convert(ConfigSettings.MIN_TEMP.get(), Temperature.Units.MC, properUnits[0], true))), true, false, false, new Component[]{Component.translatable((String)"cold_sweat.config.min_temperature.desc")});
        this.addDecimalInput("temp_damage", AbstractConfigPage.Side.LEFT, (Component)Component.translatable((String)"cold_sweat.config.temp_damage.name"), value -> ConfigSettings.TEMP_DAMAGE.set((Double)value), input -> input.setValue(String.valueOf(ConfigSettings.TEMP_DAMAGE.get())), true, true, false, new Component[]{Component.translatable((String)"cold_sweat.config.temp_damage.desc")});
        this.addDecimalInput("rate", AbstractConfigPage.Side.LEFT, (Component)Component.translatable((String)"cold_sweat.config.temperature_rate.name"), value -> ConfigSettings.TEMP_RATE.set(Math.max(0.0, value)), input -> input.setValue(String.valueOf(ConfigSettings.TEMP_RATE.get())), true, true, false, new Component[]{Component.translatable((String)"cold_sweat.config.temperature_rate.desc")});
        this.addButton("difficulty", AbstractConfigPage.Side.RIGHT, () -> Component.translatable((String)"cold_sweat.config.difficulty.name").append(" (" + ConfigSettings.Difficulty.getFormattedName(ConfigSettings.DIFFICULTY.get()).getString() + ")..."), button -> MINECRAFT.setScreen((Screen)new ConfigPageDifficulty(this)), true, false, false, new Component[]{Component.translatable((String)"cold_sweat.config.difficulty.desc")});
        this.addButton("temp_effects", AbstractConfigPage.Side.RIGHT, () -> Component.translatable((String)"cold_sweat.config.temp_effects.name"), button -> MINECRAFT.setScreen((Screen)new ConfigPageTempEffects(this)), true, false, false, new Component[]{Component.translatable((String)"cold_sweat.config.temp_effects.desc")});
        this.addButton("ice_resistance", AbstractConfigPage.Side.RIGHT, () -> this.getToggleButtonText(Component.translatable((String)"cold_sweat.config.ice_resistance.name"), ConfigSettings.ICE_RESISTANCE_ENABLED.get()), button -> ConfigSettings.ICE_RESISTANCE_ENABLED.set(ConfigSettings.ICE_RESISTANCE_ENABLED.get() == false), true, true, false, new Component[]{Component.translatable((String)"cold_sweat.config.ice_resistance.desc")});
        this.addButton("fire_resistance", AbstractConfigPage.Side.RIGHT, () -> this.getToggleButtonText(Component.translatable((String)"cold_sweat.config.fire_resistance.name"), ConfigSettings.FIRE_RESISTANCE_ENABLED.get()), button -> ConfigSettings.FIRE_RESISTANCE_ENABLED.set(ConfigSettings.FIRE_RESISTANCE_ENABLED.get() == false), true, true, false, new Component[]{Component.translatable((String)"cold_sweat.config.fire_resistance.desc")});
        this.addButton("require_thermometer", AbstractConfigPage.Side.RIGHT, () -> this.getToggleButtonText(Component.translatable((String)"cold_sweat.config.require_thermometer.name"), ConfigSettings.REQUIRE_THERMOMETER.get()), button -> ConfigSettings.REQUIRE_THERMOMETER.set(ConfigSettings.REQUIRE_THERMOMETER.get() == false), true, true, false, new Component[]{Component.translatable((String)"cold_sweat.config.require_thermometer.desc")});
        this.addButton("use_peaceful", AbstractConfigPage.Side.RIGHT, () -> this.getToggleButtonText(Component.translatable((String)"cold_sweat.config.use_peaceful.name"), ConfigSettings.USE_PEACEFUL_MODE.get()), button -> ConfigSettings.USE_PEACEFUL_MODE.set(ConfigSettings.USE_PEACEFUL_MODE.get() == false), true, true, false, new Component[]{Component.translatable((String)"cold_sweat.config.use_peaceful.desc")});
    }
}

