/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.momosoftworks.coldsweat.client.gui.AbstractHearthScreen;
import com.momosoftworks.coldsweat.common.blockentity.HearthBlockEntity;
import com.momosoftworks.coldsweat.common.container.IceboxContainer;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.util.math.CSMath;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

public class IceboxScreen
extends AbstractHearthScreen<IceboxContainer> {
    private static final ResourceLocation ICEBOX_GUI = ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"textures/gui/screen/icebox_gui.png");

    @Override
    HearthBlockEntity getBlockEntity() {
        return ((IceboxContainer)this.menu).te;
    }

    public IceboxScreen(IceboxContainer screenContainer, Inventory inv, Component titleIn) {
        super(screenContainer, inv, titleIn);
        this.imageWidth = 176;
        this.imageHeight = 172;
        this.inventoryLabelY = this.imageHeight - 94;
        this.titleLabelX = this.leftPos + this.imageWidth / 2 - Minecraft.getInstance().font.width((FormattedText)this.getTitle()) / 2;
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
    }

    @Override
    public void init() {
        super.init();
        if (this.particleButton != null) {
            this.particleButton.setX(this.leftPos + 151);
            this.particleButton.setY(this.topPos + 63);
        }
    }

    protected void renderBg(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        graphics.blit(ICEBOX_GUI, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        graphics.blit(ICEBOX_GUI, this.leftPos + 109, this.topPos + 63, 176.0f, 0.0f, (int)((double)((IceboxContainer)this.menu).te.getFuel() / 31.25), 14, 256, 256);
        if (!ConfigSettings.SMART_HEARTH.get().booleanValue() && ((IceboxContainer)this.menu).te.hasSmokeStack()) {
            boolean powered = ((IceboxContainer)this.menu).te.isCoolingOn();
            graphics.blit(ICEBOX_GUI, this.leftPos + 117, this.topPos + 78, 176.0f, powered ? 14.0f : 22.0f, 14, 8, 256, 256);
            if (CSMath.betweenInclusive(mouseX, this.leftPos + 114, this.leftPos + 132) && CSMath.betweenInclusive(mouseY, this.topPos + 78, this.topPos + 86)) {
                this.setTooltipForNextRenderPass((Component)Component.translatable((String)(powered ? "gui.cold_sweat.hearth.powered" : "gui.cold_sweat.hearth.unpowered")));
            }
        }
    }
}

