/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.client.event;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.momosoftworks.coldsweat.api.temperature.modifier.WaterTempModifier;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.data.codec.util.IntegerBounds;
import com.momosoftworks.coldsweat.util.math.CSMath;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RenderGuiEvent;
import org.joml.Matrix4f;
import org.joml.Vector2f;
import org.joml.Vector2fc;
import org.joml.Vector2i;
import oshi.util.tuples.Triplet;

@EventBusSubscriber(value={Dist.CLIENT})
public class WetnessRenderer {
    private static final ResourceLocation WATER_DROP = ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"textures/gui/overlay/droplet.png");
    private static final ResourceLocation WATER_DROP_TRAIL = ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"textures/gui/overlay/droplet_trail.png");
    private static final List<Droplet> WATER_DROPS = new ArrayList<Droplet>();
    private static final List<Triplet<Vector2i, Float, Integer>> TRAILS = new ArrayList<Triplet<Vector2i, Float, Integer>>();
    private static boolean WAS_SUBMERGED = false;

    @SubscribeEvent
    public static void updateSkyBrightness(ClientTickEvent.Pre event) {
        ClientLevel level = Minecraft.getInstance().level;
        if (level != null) {
            level.updateSkyBrightness();
        }
    }

    @SubscribeEvent
    public static void onRenderOverlay(RenderGuiEvent.Pre event) {
        boolean justExitedWater;
        LocalPlayer player;
        if (!ConfigSettings.WATER_EFFECT_SETTING.get().showGui()) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        float frametime = mc.getTimer().getRealtimeDeltaTicks();
        int screenWidth = mc.getWindow().getGuiScaledWidth();
        int screenHeight = mc.getWindow().getGuiScaledHeight();
        boolean paused = mc.isPaused();
        int uiScale = (Integer)mc.options.guiScale().get();
        if (uiScale == 0) {
            uiScale = mc.getWindow().calculateScale(0, mc.isEnforceUnicode());
        }
        if ((player = mc.player) == null) {
            return;
        }
        BlockPos playerPos = player.blockPosition();
        float playerYVelocity = (float)(player.position().y - player.yOld);
        boolean isSubmerged = player.getEyeInFluidType() == Fluids.WATER.getFluidType();
        int light = player.level().getMaxLocalRawBrightness(playerPos.above());
        if (player.hasEffect(MobEffects.NIGHT_VISION)) {
            light = 15;
        }
        float brightness = CSMath.blend(0.0f, 1.0f, light, 0.0f, 15.0f);
        float tempMult = (float)CSMath.blend(0.3, 6.0, Temperature.get((LivingEntity)player, Temperature.Trait.WORLD), ConfigSettings.MIN_TEMP.get(), ConfigSettings.MAX_TEMP.get() * 2.0);
        if (isSubmerged && !paused) {
            TRAILS.clear();
            for (Droplet drop : WATER_DROPS) {
                drop.alpha -= 0.6f * frametime;
                float xMoveDir = drop.position.x < (float)screenWidth / 2.0f ? -1.0f : 1.0f;
                float yMoveDir = drop.position.y < (float)screenHeight / 2.0f ? -1.0f : 1.0f;
                drop.position.add((Vector2fc)new Vector2f(xMoveDir, yMoveDir).mul(200.0f * -playerYVelocity * frametime));
            }
        }
        double wetness = Temperature.getModifier((LivingEntity)mc.player, Temperature.Trait.WORLD, WaterTempModifier.class).map(arg_0 -> WetnessRenderer.lambda$onRenderOverlay$0((Player)player, arg_0)).orElse(0.0);
        boolean bl = justExitedWater = WAS_SUBMERGED && !isSubmerged;
        if (justExitedWater) {
            for (int i = 0; i < 10; ++i) {
                Droplet newDrop = WetnessRenderer.createDrop(screenWidth);
                newDrop.yMotion = WetnessRenderer.getRandomVelocity(frametime) / 2.0f + 0.3f;
                newDrop.position.y = (float)Math.random() * (float)screenHeight;
                WATER_DROPS.add(newDrop);
                int streakLength = (int)(Math.random() * 5.0) + 5;
                int x = (int)newDrop.position.x;
                int y = (int)newDrop.position.y;
                for (int j = 1; j < streakLength; ++j) {
                    TRAILS.add((Triplet<Vector2i, Float, Integer>)new Triplet((Object)new Vector2i(x, y - j), (Object)Float.valueOf(CSMath.blend(newDrop.alpha * 0.8f, 0.0f, j, 1.0f, streakLength)), (Object)(newDrop.size / 2)));
                }
            }
        }
        boolean bl2 = WAS_SUBMERGED = player.isAlive() && isSubmerged;
        if (!paused && !isSubmerged && wetness > (double)0.01f && (double)((float)Math.random()) * 0.05 < (double)0.0015f * wetness * (double)(frametime * 2.0f) && WATER_DROPS.size() < 5) {
            WATER_DROPS.add(WetnessRenderer.createDrop(screenWidth));
        }
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        RenderSystem.enableBlend();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)WATER_DROP);
        GuiGraphics graphics = event.getGuiGraphics();
        BufferBuilder bufferBuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        for (int i = 0; i < WATER_DROPS.size(); ++i) {
            Droplet drop = WATER_DROPS.get(i);
            Vector2f pos = drop.position;
            float alpha = drop.alpha;
            int size = drop.size / uiScale * 3;
            drop.size = ConfigSettings.WATER_DROPLET_SCALE.get().clamp(drop.size);
            if (alpha > 0.0f) {
                WetnessRenderer.renderQuad(graphics, bufferBuilder, (int)CSMath.roundNearest(pos.x, 3.0f / (float)uiScale), (int)pos.y, size, size, 0.0f, 0.0f, 1.0f, 1.0f, brightness, brightness, brightness, alpha);
                if (!paused) {
                    drop.alpha = wetness <= 0.0 ? (drop.alpha -= 0.08f * frametime) : (drop.alpha -= 0.003f * frametime * tempMult);
                    if (drop.yMotionUpdateCooldown <= 0.0f) {
                        drop.yMotionUpdateCooldown = (float)Math.random() * 16.0f + 8.0f;
                        drop.yMotion = WetnessRenderer.getRandomVelocity(frametime);
                    } else {
                        drop.yMotionUpdateCooldown -= frametime;
                    }
                    float dropMoveFromPlayerLook = -(player.yHeadRot - player.yHeadRotO) / 20.0f;
                    dropMoveFromPlayerLook = (float)CSMath.shrink(dropMoveFromPlayerLook, 0.5);
                    drop.xVelocity = (float)CSMath.maxAbs((double)dropMoveFromPlayerLook * (Math.random() * 0.2), drop.xVelocity);
                    drop.xVelocity /= 1.0f + 0.6f * frametime;
                    if (drop.XMotionUpdateCooldown <= 0.0f) {
                        drop.XMotionUpdateCooldown = (float)Math.random() * 8.0f + 4.0f;
                        drop.xMotion = (float)Math.random() * 0.02f - 0.01f;
                    }
                    drop.XMotionUpdateCooldown -= frametime;
                    int oldY = (int)pos.y;
                    if (!isSubmerged) {
                        drop.position.add((Vector2fc)new Vector2f(drop.xMotion * drop.yMotion * 20.0f + drop.xVelocity, drop.yMotion).div((float)uiScale).mul(3.0f));
                    }
                    for (int j = 0; j < Math.max(0, (int)(pos.y - (float)oldY)); ++j) {
                        TRAILS.add((Triplet<Vector2i, Float, Integer>)new Triplet((Object)new Vector2i((int)pos.x, oldY + j), (Object)Float.valueOf(alpha), (Object)size));
                    }
                }
                if (pos.x < -20.0f) {
                    pos.x = screenWidth + 20;
                } else if (pos.x > (float)(screenWidth + 20)) {
                    pos.x = -20.0f;
                }
                if (!(pos.y > (float)screenHeight)) continue;
                WATER_DROPS.remove(drop);
                --i;
                continue;
            }
            WATER_DROPS.remove(drop);
            --i;
        }
        MeshData meshData = bufferBuilder.build();
        if (meshData != null) {
            BufferUploader.drawWithShader((MeshData)meshData);
        }
        bufferBuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)WATER_DROP_TRAIL);
        for (int i = 0; i < TRAILS.size(); ++i) {
            Triplet<Vector2i, Float, Integer> trail = TRAILS.get(i);
            Vector2i pos = (Vector2i)trail.getA();
            float alpha = ((Float)trail.getB()).floatValue();
            int size = (Integer)trail.getC();
            size = ConfigSettings.WATER_DROPLET_SCALE.get().clamp(size);
            if (alpha > 0.0f) {
                WetnessRenderer.renderQuad(graphics, bufferBuilder, (int)CSMath.roundNearest(pos.x, 3.0f / (float)uiScale * 4.0f), pos.y, size, 1, 0.0f, 0.0f, 1.0f, 1.0f, brightness, brightness, brightness, alpha);
                if (paused) continue;
                TRAILS.set(i, (Triplet<Vector2i, Float, Integer>)new Triplet((Object)new Vector2i(pos.x, pos.y), (Object)Float.valueOf(alpha - 0.045f * frametime), (Object)size));
                continue;
            }
            TRAILS.remove(trail);
            --i;
        }
        meshData = bufferBuilder.build();
        if (meshData != null) {
            BufferUploader.drawWithShader((MeshData)meshData);
        }
    }

    private static float getRandomVelocity(float frametime) {
        return (float)Math.min((double)(0.7f * frametime * 20.0f), Math.pow(Math.random() * 5.0 + (double)0.1f, 3.0) * (double)frametime / 4.0);
    }

    private static Droplet createDrop(int screenWidth) {
        IntegerBounds dropSize = ConfigSettings.WATER_DROPLET_SCALE.get();
        int size = dropSize.getRandom();
        int x = (int)(Math.random() < 0.5 ? Math.random() * (double)screenWidth / 4.0 : (double)screenWidth - Math.random() * (double)screenWidth / 4.0);
        return new Droplet(new Vector2f((float)x, (float)(-size)), 1.0f, size);
    }

    private static void renderQuad(GuiGraphics graphics, BufferBuilder bufferBuilder, int x, int y, int width, int height, float u, float v, float uWidth, float vHeight, float r, float g, float b, float a) {
        Matrix4f lastPose = graphics.pose().last().pose();
        bufferBuilder.addVertex(lastPose, (float)x, (float)y, 0.0f).setUv(u, v).setColor(r, g, b, a);
        bufferBuilder.addVertex(lastPose, (float)x, (float)(y + height), 0.0f).setUv(u, v + vHeight).setColor(r, g, b, a);
        bufferBuilder.addVertex(lastPose, (float)(x + width), (float)(y + height), 0.0f).setUv(u + uWidth, v + vHeight).setColor(r, g, b, a);
        bufferBuilder.addVertex(lastPose, (float)(x + width), (float)y, 0.0f).setUv(u + uWidth, v).setColor(r, g, b, a);
    }

    private static /* synthetic */ Double lambda$onRenderOverlay$0(Player player, WaterTempModifier mod) {
        return CSMath.blend(0.0, 1.0, mod.getWetness(), 0.0, mod.getMaxStrength((LivingEntity)player));
    }

    protected static class Droplet {
        public Vector2f position;
        public float alpha;
        public int size;
        public float yMotion = (float)Math.random() * 0.05f + 0.05f;
        public float xMotion = (float)Math.random() * 0.02f - 0.01f;
        public float xVelocity = 0.0f;
        public float yMotionUpdateCooldown = (float)Math.random() * 16.0f + 8.0f;
        public float XMotionUpdateCooldown = 16.0f;

        public Droplet(Vector2f position, float alpha, int size) {
            this.position = position;
            this.alpha = alpha;
            this.size = size;
        }
    }
}

