/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.client.event;

import com.mojang.blaze3d.shaders.Uniform;
import com.mojang.blaze3d.systems.RenderSystem;
import com.momosoftworks.coldsweat.api.event.vanilla.RenderLevelEvent;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.client.gui.Overlays;
import com.momosoftworks.coldsweat.client.renderer.PostProcessShaderManager;
import com.momosoftworks.coldsweat.common.capability.handler.EntityTempManager;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.core.init.ModEffects;
import com.momosoftworks.coldsweat.util.math.CSMath;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RenderGuiLayerEvent;
import net.neoforged.neoforge.client.event.ViewportEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;

@EventBusSubscriber(value={Dist.CLIENT})
public class TempEffectsClient {
    static float BLEND_TEMP = 0.0f;
    static float PREV_X_SWAY = 0.0f;
    static float PREV_Y_SWAY = 0.0f;
    static float X_SWAY_SPEED = 0.0f;
    static float Y_SWAY_SPEED = 0.0f;
    static float X_SWAY_PHASE = 0.0f;
    static float Y_SWAY_PHASE = 0.0f;
    static float TIME_SINCE_NEW_SWAY = 0.0f;
    static double COLD_IMMUNITY = 0.0;
    static double HOT_IMMUNITY = 0.0;
    static final ResourceLocation HAZE_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"textures/gui/overlay/haze.png");
    static final ResourceLocation FREEZE_TEXTURE = ResourceLocation.withDefaultNamespace((String)"textures/misc/powder_snow_outline.png");

    @SubscribeEvent
    public static void setCamera(ViewportEvent.ComputeCameraAngles event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (TempEffectsClient.isPlayerInvalid((Player)player)) {
            return;
        }
        if (!Minecraft.getInstance().isPaused()) {
            float frameTime = Minecraft.getInstance().getTimer().getRealtimeDeltaTicks();
            BLEND_TEMP = (float)Overlays.BLEND_BODY_TEMP;
            if (ConfigSettings.DISTORTION_EFFECTS.get().booleanValue()) {
                if (BLEND_TEMP <= -50.0f && COLD_IMMUNITY < 1.0) {
                    double tickTime = (double)player.tickCount + event.getPartialTick();
                    float shiverIntensity = CSMath.blend(((float)Math.sin(tickTime / 10.0) + 1.0f) * 0.03f + 0.01f, 0.0f, BLEND_TEMP, -100.0f, -50.0f);
                    shiverIntensity = (float)((double)shiverIntensity * ConfigSettings.SHIVER_INTENSITY.get());
                    shiverIntensity *= Minecraft.getInstance().getTimer().getRealtimeDeltaTicks() * 10.0f;
                    shiverIntensity = (float)CSMath.blend((double)shiverIntensity, 0.0, COLD_IMMUNITY, 0.0, 1.0);
                    float shiverRotation = (float)(Math.sin(tickTime * 2.5) * (double)shiverIntensity);
                    player.setYRot(player.getYRot() + shiverRotation);
                } else if (BLEND_TEMP >= 50.0f && HOT_IMMUNITY < 1.0) {
                    float factor = CSMath.blend(0.0f, 20.0f, BLEND_TEMP, 50.0f, 100.0f);
                    factor = (float)CSMath.blend((double)factor, 0.0, HOT_IMMUNITY, 0.0, 1.0);
                    factor = (float)((double)factor * ConfigSettings.HEATSTROKE_SWAY_AMOUNT.get());
                    if (TIME_SINCE_NEW_SWAY > 100.0f || X_SWAY_SPEED == 0.0f || Y_SWAY_SPEED == 0.0f) {
                        TIME_SINCE_NEW_SWAY = 0.0f;
                        X_SWAY_SPEED = (float)((Math.random() * (double)0.003f + (double)0.004f) * ConfigSettings.HEATSTROKE_SWAY_SPEED.get());
                        Y_SWAY_SPEED = (float)((Math.random() * (double)0.003f + (double)0.004f) * ConfigSettings.HEATSTROKE_SWAY_SPEED.get());
                    }
                    TIME_SINCE_NEW_SWAY += frameTime;
                    X_SWAY_PHASE = (float)((double)X_SWAY_PHASE + Math.PI * 2 * (double)frameTime * (double)X_SWAY_SPEED);
                    Y_SWAY_PHASE = (float)((double)Y_SWAY_PHASE + Math.PI * 2 * (double)frameTime * (double)Y_SWAY_SPEED);
                    float xOffs = (float)(Math.sin(X_SWAY_PHASE) * (double)factor);
                    float yOffs = (float)((Math.sin(Y_SWAY_PHASE) + Math.cos(Y_SWAY_PHASE / 4.0f) * 2.0) * (double)factor * 3.0);
                    player.setXRot(player.getXRot() + xOffs - PREV_X_SWAY);
                    player.setYRot(player.getYRot() + yOffs - PREV_Y_SWAY);
                    PREV_X_SWAY = xOffs;
                    PREV_Y_SWAY = yOffs;
                } else {
                    PREV_X_SWAY = 0.0f;
                    PREV_Y_SWAY = 0.0f;
                    X_SWAY_PHASE = 0.0f;
                    Y_SWAY_PHASE = 0.0f;
                }
            }
        }
    }

    @SubscribeEvent
    public static void onClientTick(ClientTickEvent.Post event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (TempEffectsClient.isPlayerInvalid((Player)player)) {
            return;
        }
        if (player.tickCount % 5 == 0) {
            COLD_IMMUNITY = player.hasEffect(ModEffects.ICE_RESISTANCE) && ConfigSettings.ICE_RESISTANCE_ENABLED.get() != false ? 1.0 : Temperature.get((LivingEntity)player, Temperature.Trait.COLD_RESISTANCE);
            HOT_IMMUNITY = player.hasEffect(MobEffects.FIRE_RESISTANCE) && ConfigSettings.FIRE_RESISTANCE_ENABLED.get() != false ? 1.0 : Temperature.get((LivingEntity)player, Temperature.Trait.HEAT_RESISTANCE);
        }
    }

    @SubscribeEvent
    public static void setFogDistance(ViewportEvent.RenderFog event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (TempEffectsClient.isPlayerInvalid((Player)player)) {
            return;
        }
        double fogDistance = ConfigSettings.HEATSTROKE_FOG_DISTANCE.get();
        if (fogDistance >= 64.0) {
            return;
        }
        if (fogDistance < Double.POSITIVE_INFINITY && BLEND_TEMP >= 50.0f && HOT_IMMUNITY < 1.0) {
            float tempWithResistance = (float)CSMath.blend((double)BLEND_TEMP, 50.0, HOT_IMMUNITY, 0.0, 1.0);
            if (fogDistance > (double)event.getFarPlaneDistance()) {
                return;
            }
            event.setFarPlaneDistance(CSMath.blend(event.getFarPlaneDistance(), (float)fogDistance, tempWithResistance, 50.0f, 90.0f));
            event.setNearPlaneDistance(CSMath.blend(event.getNearPlaneDistance(), (float)(fogDistance * 0.3), tempWithResistance, 50.0f, 90.0f));
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void setFogColor(ViewportEvent.ComputeFogColor event) {
        LocalPlayer player = Minecraft.getInstance().player;
        double fogDistance = ConfigSettings.HEATSTROKE_FOG_DISTANCE.get();
        if (fogDistance >= 64.0) {
            return;
        }
        if (fogDistance < Double.POSITIVE_INFINITY && player != null && BLEND_TEMP >= 50.0f && HOT_IMMUNITY < 4.0) {
            float tempWithResistance = (float)CSMath.blend((double)BLEND_TEMP, 50.0, HOT_IMMUNITY, 0.0, 4.0);
            event.setRed(CSMath.blend(event.getRed(), 0.01f, tempWithResistance, 50.0f, 90.0f));
            event.setGreen(CSMath.blend(event.getGreen(), 0.01f, tempWithResistance, 50.0f, 90.0f));
            event.setBlue(CSMath.blend(event.getBlue(), 0.05f, tempWithResistance, 50.0f, 90.0f));
        }
    }

    @SubscribeEvent
    public static void vignette(RenderGuiLayerEvent.Pre event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (TempEffectsClient.isPlayerInvalid((Player)player)) {
            return;
        }
        if (event.getName() == VanillaGuiLayers.CAMERA_OVERLAYS && (BLEND_TEMP > 0.0f && HOT_IMMUNITY < 1.0 || BLEND_TEMP < 0.0f && COLD_IMMUNITY < 1.0)) {
            ResourceLocation texture;
            float resistance = (float)CSMath.blend(1.0, 0.0, BLEND_TEMP > 0.0f ? HOT_IMMUNITY : COLD_IMMUNITY, 0.0, 1.0);
            float opacity = CSMath.blend(0.0f, 1.0f, Math.abs(BLEND_TEMP), 50.0f, 100.0f) * resistance;
            float tickTime = (float)player.tickCount + event.getPartialTick().getGameTimeDeltaPartialTick(true);
            if (opacity == 0.0f) {
                return;
            }
            float width = event.getGuiGraphics().guiWidth();
            float height = event.getGuiGraphics().guiHeight();
            float scale = Minecraft.getInstance().getWindow().calculateScale(((Integer)Minecraft.getInstance().options.guiScale().get()).intValue(), Minecraft.getInstance().isEnforceUnicode());
            RenderSystem.disableDepthTest();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            if (BLEND_TEMP > 0.0f) {
                float vignetteBrightness = opacity + ((float)Math.sin((double)(tickTime + 3.0f) / 3.18306181683261) / 5.0f - 0.2f) * opacity;
                RenderSystem.setShaderColor((float)0.231f, (float)0.0f, (float)0.0f, (float)vignetteBrightness);
                texture = HAZE_TEXTURE;
            } else {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)opacity);
                texture = FREEZE_TEXTURE;
            }
            event.getGuiGraphics().blit(texture, 0, 0, -90, 0.0f, 0.0f, (int)width, (int)height, (int)width, (int)height);
            RenderSystem.depthMask((boolean)true);
            RenderSystem.enableDepthTest();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.defaultBlendFunc();
        }
    }

    @SubscribeEvent
    public static void onRenderBlur(RenderLevelEvent.Post event) {
        if (TempEffectsClient.isPlayerInvalid((Player)Minecraft.getInstance().player)) {
            return;
        }
        double blurMultiplier = ConfigSettings.HEATSTROKE_BLUR_AMOUNT.get();
        if (blurMultiplier == 0.0) {
            return;
        }
        PostProcessShaderManager shaderManager = PostProcessShaderManager.getInstance();
        if (ConfigSettings.DISTORTION_EFFECTS.get().booleanValue() && BLEND_TEMP >= 50.0f && HOT_IMMUNITY < 1.0) {
            Uniform blurRadius;
            float blur = CSMath.blend(0.0f, 12.0f, BLEND_TEMP, 50.0f, 100.0f);
            blur = (float)CSMath.blend((double)blur, 0.0, HOT_IMMUNITY, 0.0, 1.0);
            blur = (float)((double)blur * blurMultiplier);
            if (!shaderManager.hasEffect("heat_blur")) {
                shaderManager.loadEffect("heat_blur", PostProcessShaderManager.BLOBS);
            }
            if ((blurRadius = shaderManager.getPostPasses("heat_blur").get(0).getEffect().getUniform("Radius")) != null) {
                blurRadius.set(blur);
            }
        } else if (shaderManager.hasEffect("heat_blur")) {
            shaderManager.closeEffect("heat_blur");
        }
        shaderManager.process(event.getPartialTick());
    }

    private static boolean isPlayerInvalid(Player player) {
        return player == null || !player.isAlive() || EntityTempManager.isPeacefulMode((LivingEntity)player) || player.hasEffect(ModEffects.GRACE);
    }
}

