/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.client.event;

import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.client.gui.Overlays;
import com.momosoftworks.coldsweat.common.capability.handler.EntityTempManager;
import com.momosoftworks.coldsweat.common.item.SoulspringLampItem;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.core.init.ModItemComponents;
import com.momosoftworks.coldsweat.core.init.ModItems;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import java.lang.reflect.Field;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.util.ObfuscationReflectionHelper;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class RegisterItemOverrides {
    public static final ItemPropertyFunction SOULSPRING_LAMP_PROPERTIES = (stack, level, entity, id) -> {
        if (SoulspringLampItem.isLit(stack)) {
            double fuel = SoulspringLampItem.getFuel(stack);
            return fuel > 43.0 ? 3.0f : (fuel > 22.0 ? 2.0f : 1.0f);
        }
        return 0.0f;
    };
    private static final Field ITEM_PROPERTIES = ObfuscationReflectionHelper.findField(ItemProperties.class, (String)"PROPERTIES");

    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            if (!ConfigSettings.ANIMATED_SOULSPRING_LAMP_MODEL.get().booleanValue()) {
                ItemProperties.register((Item)((Item)ModItems.SOULSPRING_LAMP.get()), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"soulspring_state"), (ItemPropertyFunction)SOULSPRING_LAMP_PROPERTIES);
            }
            ItemProperties.register((Item)((Item)ModItems.FILLED_WATERSKIN.get()), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"water_temperature"), (stack, level, entity, id) -> ((Double)stack.getOrDefault(ModItemComponents.WATER_TEMPERATURE, (Object)0.0)).floatValue());
            ItemProperties.register((Item)((Item)ModItems.THERMOMETER.get()), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"temperature"), (stack, level, livingEntity, id) -> {
                LivingEntity entity;
                Object object = entity = livingEntity != null ? livingEntity : stack.getEntityRepresentation();
                if (entity != null) {
                    ItemFrame frame;
                    double worldTemp;
                    double maxTemp;
                    double minTemp = livingEntity != null ? Temperature.get(livingEntity, Temperature.Trait.FREEZING_POINT) : ConfigSettings.MIN_TEMP.get();
                    double d = maxTemp = livingEntity != null ? Temperature.get(livingEntity, Temperature.Trait.BURNING_POINT) : ConfigSettings.MAX_TEMP.get();
                    if (!entity.getPersistentData().contains("WorldTempTimestamp") || (entity.tickCount % 20 == 0 || entity instanceof Player && entity.tickCount % 2 == 0) && entity.getPersistentData().getInt("WorldTempTimestamp") != entity.tickCount) {
                        double d2;
                        if (entity instanceof LivingEntity) {
                            LivingEntity living = entity;
                            d2 = EntityTempManager.getTemperatureCap((Entity)living).map(cap -> cap.getTrait(Temperature.Trait.WORLD)).orElse(0.0);
                        } else {
                            d2 = WorldHelper.getTemperatureAt(entity.level(), entity.blockPosition());
                        }
                        worldTemp = d2;
                        entity.getPersistentData().putDouble("WorldTemp", worldTemp);
                        entity.getPersistentData().putInt("WorldTempTimestamp", entity.tickCount);
                    } else {
                        worldTemp = entity.getPersistentData().getDouble("WorldTemp");
                    }
                    if (entity instanceof ItemFrame && Minecraft.getInstance().getEntityRenderDispatcher().crosshairPickEntity == (frame = (ItemFrame)entity)) {
                        boolean celsius = ConfigSettings.CELSIUS.get();
                        ChatFormatting tempColor = switch (Overlays.getGaugeSeverity(worldTemp, minTemp, maxTemp)) {
                            case 0 -> ChatFormatting.WHITE;
                            case 2, 3 -> ChatFormatting.GOLD;
                            case 4 -> ChatFormatting.RED;
                            case -3, -2 -> ChatFormatting.AQUA;
                            case -4 -> ChatFormatting.BLUE;
                            default -> ChatFormatting.RESET;
                        };
                        int convertedTemp = (int)Temperature.convert(worldTemp, Temperature.Units.MC, celsius ? Temperature.Units.C : Temperature.Units.F, true) + ConfigSettings.TEMP_OFFSET.get();
                        frame.getItem().set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)(convertedTemp + " " + (celsius ? Temperature.Units.C.getFormattedName() : Temperature.Units.F.getFormattedName()))).withStyle(tempColor));
                    }
                    double worldTempAdjusted = Overlays.getWorldSeverity(worldTemp, minTemp, maxTemp) * 1.01;
                    return (float)worldTempAdjusted;
                }
                return 0.0f;
            });
        });
    }

    public static void unregister(Item item) {
        try {
            Map properties = (Map)ITEM_PROPERTIES.get(null);
            properties.remove(item);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        ITEM_PROPERTIES.setAccessible(true);
    }
}

