/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.api.temperature.modifier;

import com.momosoftworks.coldsweat.api.event.common.temperautre.TempModifierEvent;
import com.momosoftworks.coldsweat.api.registry.TempModifierRegistry;
import com.momosoftworks.coldsweat.api.util.Temperature;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;

public abstract class TempModifier {
    private CompoundTag nbt = new CompoundTag();
    private int expireTicks = -1;
    private int ticksExisted = 0;
    private int tickRate = 1;
    private final Map<Temperature.Trait, Double> lastInput = new EnumMap<Temperature.Trait, Double>(Temperature.Trait.class);
    private final Map<Temperature.Trait, Double> lastOutput = new EnumMap<Temperature.Trait, Double>(Temperature.Trait.class);
    private final Map<Temperature.Trait, Function<Double, Double>> function = new EnumMap<Temperature.Trait, Function<Double, Double>>(Temperature.Trait.class);
    private boolean changed = false;

    public final <T extends TempModifier> T tickRate(int interval) {
        this.tickRate = Math.max(1, interval);
        return (T)this;
    }

    public final <T extends TempModifier> T expires(int ticks) {
        this.expireTicks = ticks;
        return (T)this;
    }

    protected abstract Function<Double, Double> calculate(LivingEntity var1, Temperature.Trait var2);

    public void tick(LivingEntity entity) {
    }

    public final double update(double temp, LivingEntity entity, Temperature.Trait trait) {
        TempModifierEvent.Calculate.Pre pre = new TempModifierEvent.Calculate.Pre(this, entity, temp, trait);
        NeoForge.EVENT_BUS.post((Event)pre);
        if (pre.isCanceled()) {
            this.function.put(trait, pre.getFunction());
            return this.apply(trait, pre.getTemperature());
        }
        TempModifierEvent.Calculate.Post post = new TempModifierEvent.Calculate.Post(this, entity, pre.getTemperature(), this.calculate(entity, trait), trait);
        NeoForge.EVENT_BUS.post((Event)post);
        this.function.put(trait, post.getFunction());
        return this.apply(trait, post.getTemperature());
    }

    public double apply(Temperature.Trait trait, double temp) {
        this.lastInput.put(trait, temp);
        double output = this.getFunction(trait).apply(temp);
        this.lastOutput.put(trait, output);
        return output;
    }

    public final int getExpireTime() {
        return this.expireTicks;
    }

    public final int getTicksExisted() {
        return this.ticksExisted;
    }

    public final int setTicksExisted(int ticks) {
        this.ticksExisted = ticks;
        return this.ticksExisted;
    }

    public final int getTickRate() {
        return this.tickRate;
    }

    public final Function<Double, Double> getFunction(Temperature.Trait trait) {
        return this.function.computeIfAbsent(trait, t -> temp -> temp);
    }

    public final double getLastInput(Temperature.Trait trait) {
        return this.lastInput.getOrDefault((Object)trait, 0.0);
    }

    public final double getLastOutput(Temperature.Trait trait) {
        return this.lastOutput.getOrDefault((Object)trait, 0.0);
    }

    public final CompoundTag getNBT() {
        return this.nbt;
    }

    public void setNBT(CompoundTag data) {
        this.nbt = data;
    }

    public String toString() {
        return TempModifierRegistry.getKey(this).toString();
    }

    public void markDirty() {
        this.changed = true;
    }

    public boolean isDirty() {
        return this.changed;
    }

    public void markClean() {
        this.changed = false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof TempModifier)) return false;
        TempModifier mod = (TempModifier)obj;
        if (!this.getClass().equals(mod.getClass())) return false;
        if (!mod.getNBT().equals((Object)this.getNBT())) return false;
        return true;
    }
}

