/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.api.temperature.modifier;

import com.momosoftworks.coldsweat.api.temperature.modifier.TempModifier;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.neoforged.neoforge.common.Tags;

public class DepthBiomeTempModifier
extends TempModifier {
    public DepthBiomeTempModifier() {
        this(6);
    }

    public DepthBiomeTempModifier(int samples) {
        this.getNBT().putInt("SampleRoot", samples);
    }

    @Override
    protected Function<Double, Double> calculate(LivingEntity entity, Temperature.Trait trait) {
        int sampleRoot = this.getNBT().getInt("SampleRoot");
        Level level = entity.level();
        double biomeTempTotal = 0.0;
        int caveBiomeCount = 0;
        for (BlockPos pos : WorldHelper.getPositionCube(entity.blockPosition(), sampleRoot, 6)) {
            Holder biome;
            if (!level.isInWorldBounds(pos) || (double)WorldHelper.getHeight(pos, level) <= entity.getY() || !(biome = level.getBiomeManager().getBiome(pos)).is(Tags.Biomes.IS_UNDERGROUND)) continue;
            double biomeTemp = CSMath.averagePair(WorldHelper.getBiomeTemperatureRange((LevelAccessor)level, (Holder<Biome>)biome));
            biomeTempTotal += biomeTemp;
            ++caveBiomeCount;
        }
        if (caveBiomeCount == 0) {
            return temp -> temp;
        }
        int finalCaveBiomeCount = caveBiomeCount;
        double biomeTempAvg = biomeTempTotal / (double)caveBiomeCount;
        return temp -> CSMath.blend(temp, biomeTempAvg, (double)finalCaveBiomeCount, 0.0, Math.pow(sampleRoot, 3.0));
    }
}

