/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.api.temperature.modifier;

import com.mojang.datafixers.util.Pair;
import com.momosoftworks.coldsweat.api.temperature.modifier.TempModifier;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.compat.CompatManager;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.data.codec.configuration.StructureTempData;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.neoforged.neoforge.common.Tags;

public class BiomeTempModifier
extends TempModifier {
    public BiomeTempModifier() {
        this(16);
    }

    public BiomeTempModifier(int samples) {
        this.getNBT().putInt("Samples", samples);
    }

    @Override
    public Function<Double, Double> calculate(LivingEntity entity, Temperature.Trait trait) {
        int samples = this.getNBT().getInt("Samples");
        double worldTemp = 0.0;
        Level level = entity.level();
        BlockPos entPos = entity.blockPosition();
        Pair<Double, Double> structureTemp = BiomeTempModifier.getStructureTemp(entity.level(), entity.blockPosition());
        if (structureTemp.getFirst() != null) {
            return temp -> (Double)structureTemp.getFirst();
        }
        int biomeCount = 0;
        for (BlockPos blockPos : level.dimensionType().hasCeiling() ? WorldHelper.getPositionCube(entPos, (int)Math.sqrt(samples), 10) : WorldHelper.getPositionGrid(entPos, samples, 10)) {
            Holder holder = level.getBiomeManager().getBiome(blockPos);
            if (holder.is(Tags.Biomes.IS_UNDERGROUND) || holder.unwrapKey().isEmpty()) continue;
            ++biomeCount;
            DimensionType dimension = level.dimensionType();
            if (!dimension.hasCeiling() && !level.dimensionType().hasFixedTime()) {
                double biomeTemp = WorldHelper.getBiomeTemperature((LevelAccessor)level, (Holder<Biome>)holder);
                if (CompatManager.isPrimalWinterLoaded() && holder.is(BiomeTags.IS_OVERWORLD)) {
                    biomeTemp = Math.min(biomeTemp, biomeTemp / 2.0) - Math.max(biomeTemp / 2.0, 0.0);
                }
                worldTemp += biomeTemp;
                continue;
            }
            worldTemp += CSMath.averagePair(WorldHelper.getBiomeTemperatureRange((LevelAccessor)level, (Holder<Biome>)holder));
        }
        worldTemp /= (double)Math.max(1, biomeCount);
        if (!level.dimensionType().hasCeiling() && level.isRaining()) {
            long time = level.getDayTime();
            double overcastTemp = ConfigSettings.OVERCAST_TEMP_OFFSET.get();
            worldTemp += CSMath.blend(0.0, overcastTemp, (double)Math.abs(6000L - time), 6000.0, 0.0);
        }
        double finalWorldTemp = worldTemp += ((Double)structureTemp.getSecond()).doubleValue();
        return temp -> temp + finalWorldTemp;
    }

    public static Pair<Double, Double> getStructureTemp(Level level, BlockPos pos) {
        if (!level.isLoaded(pos)) {
            return Pair.of(null, (Object)0.0);
        }
        Optional<Holder<Structure>> structure = WorldHelper.getStructureAt(level, pos);
        if (structure.isEmpty()) {
            return Pair.of(null, (Object)0.0);
        }
        Double strucTemp = CSMath.getIfNotNull(ConfigSettings.STRUCTURE_TEMPS.get(level.registryAccess()).get(structure.get()), StructureTempData::getTemperature, null);
        Double strucOffset = CSMath.getIfNotNull(ConfigSettings.STRUCTURE_OFFSETS.get(level.registryAccess()).get(structure.get()), StructureTempData::getTemperature, 0.0);
        return Pair.of((Object)strucTemp, (Object)strucOffset);
    }
}

