/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.api.registry;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.momosoftworks.coldsweat.ColdSweat;
import com.momosoftworks.coldsweat.api.temperature.modifier.TempModifier;
import com.momosoftworks.coldsweat.util.exceptions.RegistryFailureException;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.math.FastBiMap;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class TempModifierRegistry {
    static FastBiMap<ResourceLocation, TempModifierHolder> TEMP_MODIFIERS = new FastBiMap();

    public static BiMap<ResourceLocation, TempModifierHolder> getEntries() {
        return ImmutableBiMap.copyOf(TEMP_MODIFIERS);
    }

    public static void register(ResourceLocation id, Supplier<TempModifier> supplier) {
        TempModifierHolder holder;
        block3: {
            block2: {
                holder = new TempModifierHolder(supplier, id);
                if (TEMP_MODIFIERS.containsKey(id)) break block2;
                if (!TEMP_MODIFIERS.values().stream().anyMatch(holder::equals)) break block3;
            }
            throw (RegistryFailureException)ColdSweat.LOGGER.throwing((Throwable)new RegistryFailureException(id, "TempModifier", String.format("Found duplicate TempModifier entries: %s (%s) %s (%s)", holder.getModifierClass().getName(), id, TEMP_MODIFIERS.get(id).getModifierClass().getName(), id), null));
        }
        TEMP_MODIFIERS.put(id, holder);
    }

    public static void flush() {
        TEMP_MODIFIERS.clear();
    }

    public static Optional<TempModifier> getValue(ResourceLocation id) {
        return Optional.ofNullable(TEMP_MODIFIERS.get(id)).map(TempModifierHolder::get);
    }

    @Nullable
    public static ResourceLocation getKey(TempModifier modifier) {
        return CSMath.getIfNotNull(TempModifierRegistry.getHolder(modifier), TempModifierHolder::getId, null);
    }

    public static boolean containsKey(ResourceLocation id) {
        return TEMP_MODIFIERS.containsKey(id);
    }

    @Nullable
    public static TempModifierHolder getHolder(TempModifier modifier) {
        for (TempModifierHolder holder : TEMP_MODIFIERS.values()) {
            if (holder.getModifierClass() != modifier.getClass()) continue;
            return holder;
        }
        return null;
    }

    public static class TempModifierHolder {
        private final Supplier<TempModifier> supplier;
        private final Class<? extends TempModifier> clazz;
        private final ResourceLocation id;

        public TempModifierHolder(Supplier<TempModifier> supplier, ResourceLocation id) {
            this.supplier = supplier;
            this.clazz = supplier.get().getClass();
            this.id = id;
        }

        public TempModifier get() {
            return this.supplier.get();
        }

        public Class<? extends TempModifier> getModifierClass() {
            return this.clazz;
        }

        public ResourceLocation getId() {
            return this.id;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            if (!(obj instanceof TempModifierHolder)) return false;
            TempModifierHolder holder = (TempModifierHolder)obj;
            if (holder.clazz != this.clazz) return false;
            return true;
        }

        public String toString() {
            return "TempModifierHolder{" + this.clazz.getName() + "}";
        }
    }
}

