/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.api.insulation.slot;

import com.mojang.serialization.Codec;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.serialization.NbtSerializable;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;

public abstract class ScalingFormula
implements NbtSerializable {
    Type scaling;

    protected ScalingFormula(Type scaling) {
        this.scaling = scaling;
    }

    public abstract int getSlots(EquipmentSlot var1, ItemStack var2);

    public abstract List<? extends Number> getValues();

    public Type getType() {
        return this.scaling;
    }

    @Override
    public CompoundTag serialize() {
        CompoundTag tag = new CompoundTag();
        tag.putString("scaling", this.scaling.getSerializedName());
        return tag;
    }

    public static ScalingFormula deserialize(CompoundTag nbt) {
        Type scaling = Type.byName(nbt.getString("scaling"));
        return switch (scaling.ordinal()) {
            case 0 -> Static.deserialize(nbt);
            default -> Dynamic.deserialize(nbt);
        };
    }

    public static enum Type implements StringRepresentable
    {
        STATIC("static"),
        LINEAR("linear"),
        EXPONENTIAL("exponential"),
        LOGARITHMIC("logarithmic");

        final String name;
        public static final Codec<Type> CODEC;

        private Type(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }

        public static Type byName(String name) {
            for (Type type : Type.values()) {
                if (!type.name.equals(name)) continue;
                return type;
            }
            throw new IllegalArgumentException("Unknown insulation scaling: " + name);
        }

        static {
            CODEC = Codec.STRING.xmap(Type::byName, Type::getSerializedName);
        }
    }

    public static class Static
    extends ScalingFormula {
        Map<EquipmentSlot, Integer> slots = new EnumMap<EquipmentSlot, Integer>(EquipmentSlot.class);

        public Static(int head, int body, int legs, int feet) {
            super(Type.STATIC);
            this.slots.put(EquipmentSlot.HEAD, head);
            this.slots.put(EquipmentSlot.CHEST, body);
            this.slots.put(EquipmentSlot.LEGS, legs);
            this.slots.put(EquipmentSlot.FEET, feet);
        }

        private Static() {
            super(Type.STATIC);
        }

        @Override
        public int getSlots(EquipmentSlot slot, ItemStack stack) {
            return this.slots.getOrDefault(slot, 0);
        }

        @Override
        public List<? extends Number> getValues() {
            return List.of(this.slots.get(EquipmentSlot.HEAD), this.slots.get(EquipmentSlot.CHEST), this.slots.get(EquipmentSlot.LEGS), this.slots.get(EquipmentSlot.FEET));
        }

        public static Static deserialize(CompoundTag nbt) {
            Static instance = new Static();
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                if (!slot.isArmor()) continue;
                instance.slots.put(slot, nbt.getInt(slot.getName()));
            }
            return instance;
        }

        @Override
        public CompoundTag serialize() {
            CompoundTag tag = super.serialize();
            for (Map.Entry<EquipmentSlot, Integer> entry : this.slots.entrySet()) {
                tag.putInt(entry.getKey().getName(), entry.getValue().intValue());
            }
            return tag;
        }
    }

    public static class Dynamic
    extends ScalingFormula {
        double factor;
        double max;

        public Dynamic(Type scaling, double factor, double max) {
            super(scaling);
            this.factor = factor;
            this.max = max;
        }

        @Override
        public int getSlots(EquipmentSlot slot, ItemStack stack) {
            double protection = stack.getAttributeModifiers().modifiers().stream().filter(entry -> entry.attribute() == Attributes.ARMOR).findFirst().map(entry -> entry.modifier().amount()).orElse(0.0);
            return switch (this.scaling.ordinal()) {
                case 1 -> (int)CSMath.clamp(Math.floor(protection * this.factor), 0.0, this.max);
                case 2 -> (int)CSMath.clamp(Math.floor(Math.pow(protection, this.factor)), 0.0, this.max);
                case 3 -> (int)CSMath.clamp(Math.floor(Math.sqrt(protection) * this.factor), 0.0, this.max);
                default -> 0;
            };
        }

        @Override
        public List<? extends Number> getValues() {
            return List.of(Double.valueOf(this.factor), Double.valueOf(this.max));
        }

        public static Dynamic deserialize(CompoundTag nbt) {
            return new Dynamic(Type.byName(nbt.getString("scaling")), nbt.getDouble("factor"), nbt.getDouble("max"));
        }

        @Override
        public CompoundTag serialize() {
            CompoundTag tag = super.serialize();
            tag.putDouble("factor", this.factor);
            tag.putDouble("max", this.max);
            return tag;
        }
    }
}

