/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.api.insulation;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.momosoftworks.coldsweat.api.insulation.Insulation;
import com.momosoftworks.coldsweat.core.init.ModItemComponents;
import com.momosoftworks.coldsweat.util.math.CSMath;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;

public class AdaptiveInsulation
extends Insulation {
    public static final Codec<AdaptiveInsulation> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.DOUBLE.fieldOf("value").forGetter(AdaptiveInsulation::getInsulation), (App)Codec.DOUBLE.optionalFieldOf("factor", (Object)0.0).forGetter(AdaptiveInsulation::getFactor), (App)Codec.DOUBLE.fieldOf("adapt_speed").forGetter(AdaptiveInsulation::getSpeed)).apply((Applicative)instance, AdaptiveInsulation::new));
    private final double insulation;
    private final double speed;
    private double factor;

    public AdaptiveInsulation(double insulation, double speed) {
        this(insulation, 0.0, speed);
    }

    public AdaptiveInsulation(double insulation, double factor, double speed) {
        this.insulation = insulation;
        this.factor = factor;
        this.speed = speed;
    }

    public static double calculateChange(AdaptiveInsulation insulation, double worldTemp, double minTemp, double maxTemp) {
        double factor = insulation.getFactor();
        double adaptSpeed = insulation.getSpeed();
        double newFactor = CSMath.betweenInclusive(CSMath.blend(-1.0, 1.0, worldTemp, minTemp, maxTemp), -0.5, 0.5) ? CSMath.shrink(factor, adaptSpeed) : CSMath.clamp(factor + CSMath.blend(-adaptSpeed, adaptSpeed, worldTemp, minTemp, maxTemp), -1.0, 1.0);
        return newFactor;
    }

    public static double getFactorFromArmor(ItemStack stack) {
        return (Double)stack.getOrDefault(ModItemComponents.ARMOR_ADAPTATION, (Object)0.0);
    }

    public static void setFactorToArmor(ItemStack stack, double factor) {
        stack.set(ModItemComponents.ARMOR_ADAPTATION, (Object)factor);
    }

    public static void readFactorFromArmor(AdaptiveInsulation insulation, ItemStack stack) {
        double storedFactor = AdaptiveInsulation.getFactorFromArmor(stack);
        if (storedFactor != 0.0) {
            insulation.setFactor(storedFactor);
        }
    }

    @Override
    public double getValue() {
        return this.insulation;
    }

    public double getInsulation() {
        return this.insulation;
    }

    public double getFactor() {
        return this.factor;
    }

    public void setFactor(double factor) {
        this.factor = factor;
    }

    public double getSpeed() {
        return this.speed;
    }

    @Override
    public double getCold() {
        return CSMath.blend(this.insulation * 0.75, 0.0, this.factor, -1.0, 1.0);
    }

    @Override
    public double getHeat() {
        return CSMath.blend(0.0, this.insulation * 0.75, this.factor, -1.0, 1.0);
    }

    @Override
    public <T extends Insulation> T copy() {
        return (T)new AdaptiveInsulation(this.insulation, this.factor, this.speed);
    }

    @Override
    public boolean isEmpty() {
        return this.insulation == 0.0;
    }

    @Override
    public List<Insulation> split() {
        ArrayList<Insulation> insulation = new ArrayList<Insulation>();
        for (int i = 0; i < CSMath.ceil(Math.abs(this.insulation) / 2.0); ++i) {
            double insul = CSMath.minAbs(CSMath.shrink(this.insulation, (double)(i * 2)), 2 * CSMath.sign(this.insulation));
            insulation.add(new AdaptiveInsulation(insul, this.factor, this.speed));
        }
        return insulation;
    }

    public String toString() {
        return "AdaptiveInsulation{insulation=" + this.insulation + ", factor=" + this.factor + ", speed=" + this.speed + "}";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AdaptiveInsulation)) return false;
        AdaptiveInsulation insul = (AdaptiveInsulation)obj;
        if (this.insulation != insul.insulation) return false;
        if (this.factor != insul.factor) return false;
        if (this.speed != insul.speed) return false;
        return true;
    }

    @Override
    public CompoundTag serialize() {
        CompoundTag tag = new CompoundTag();
        tag.putDouble("insulation", this.insulation);
        tag.putDouble("factor", this.factor);
        tag.putDouble("speed", this.speed);
        return tag;
    }

    public static AdaptiveInsulation deserialize(CompoundTag tag) {
        return new AdaptiveInsulation(tag.getDouble("insulation"), tag.getDouble("factor"), tag.getDouble("speed"));
    }
}

