/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.api.event.core.registry;

import com.momosoftworks.coldsweat.ColdSweat;
import com.momosoftworks.coldsweat.api.registry.TempModifierRegistry;
import com.momosoftworks.coldsweat.api.temperature.modifier.TempModifier;
import com.momosoftworks.coldsweat.util.exceptions.RegistryFailureException;
import java.lang.reflect.Constructor;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.Event;

public class TempModifierRegisterEvent
extends Event {
    public void register(ResourceLocation id, Supplier<TempModifier> modifier) {
        TempModifierRegistry.register(id, modifier);
    }

    public void registerByClassName(ResourceLocation id, String classPath) {
        try {
            Constructor<?> clazz = Class.forName(classPath).getConstructor(new Class[0]);
            this.register(id, () -> {
                try {
                    return (TempModifier)clazz.newInstance(new Object[0]);
                }
                catch (Exception e) {
                    throw (RegistryFailureException)ColdSweat.LOGGER.throwing((Throwable)new RegistryFailureException(id, "TempModifier", "Failed to instantiate class " + classPath, e));
                }
            });
        }
        catch (Exception e) {
            throw (RegistryFailureException)ColdSweat.LOGGER.throwing((Throwable)new RegistryFailureException(id, "TempModifier", e.getMessage(), e));
        }
    }
}

