/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.api.event.core.registry;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.momosoftworks.coldsweat.data.codec.configuration.RemoveRegistryData;
import com.momosoftworks.coldsweat.data.codec.impl.ConfigData;
import java.util.Collection;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.neoforged.bus.api.Event;

public abstract class CreateRegistriesEvent
extends Event {
    RegistryAccess registryAccess;
    Multimap<ResourceKey<Registry<? extends ConfigData>>, Holder<? extends ConfigData>> registries;

    public CreateRegistriesEvent(RegistryAccess registryAccess, Multimap<ResourceKey<Registry<? extends ConfigData>>, Holder<? extends ConfigData>> registries) {
        this.registryAccess = registryAccess;
        this.registries = registries;
    }

    public RegistryAccess getRegistryAccess() {
        return this.registryAccess;
    }

    public Multimap<ResourceKey<Registry<? extends ConfigData>>, Holder<? extends ConfigData>> getRegistries() {
        return this.registries;
    }

    public <T> Collection<Holder<T>> getRegistry(ResourceKey<Registry<T>> key) {
        return this.registries.get(key);
    }

    public static class Post
    extends CreateRegistriesEvent {
        public Post(RegistryAccess registryAccess, Multimap<ResourceKey<Registry<? extends ConfigData>>, Holder<? extends ConfigData>> registries) {
            super(registryAccess, registries);
        }
    }

    public static class Pre
    extends CreateRegistriesEvent {
        private Multimap<ResourceKey<Registry<? extends ConfigData>>, RemoveRegistryData<?>> removals;

        public Pre(RegistryAccess registryAccess, Multimap<ResourceKey<Registry<? extends ConfigData>>, Holder<? extends ConfigData>> registries, Multimap<ResourceKey<Registry<? extends ConfigData>>, RemoveRegistryData<?>> removals) {
            super(registryAccess, registries);
        }

        public Multimap<ResourceKey<Registry<? extends ConfigData>>, RemoveRegistryData<?>> getRegistryRemovals() {
            return ImmutableMultimap.copyOf(this.removals);
        }
    }
}

