/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat;

import com.momosoftworks.coldsweat.common.blockentity.HearthBlockEntity;
import com.momosoftworks.coldsweat.common.capability.ModCapabilities;
import com.momosoftworks.coldsweat.common.capability.handler.EntityTempManager;
import com.momosoftworks.coldsweat.common.capability.shearing.ShearableFurCap;
import com.momosoftworks.coldsweat.common.capability.temperature.EntityTempCap;
import com.momosoftworks.coldsweat.common.capability.temperature.PlayerTempCap;
import com.momosoftworks.coldsweat.common.entity.Chameleon;
import com.momosoftworks.coldsweat.compat.CompatManager;
import com.momosoftworks.coldsweat.config.ModUpdater;
import com.momosoftworks.coldsweat.config.spec.ClientSettingsConfig;
import com.momosoftworks.coldsweat.config.spec.EntitySettingsConfig;
import com.momosoftworks.coldsweat.config.spec.ItemSettingsConfig;
import com.momosoftworks.coldsweat.config.spec.MainSettingsConfig;
import com.momosoftworks.coldsweat.config.spec.WorldSettingsConfig;
import com.momosoftworks.coldsweat.core.init.ModAdvancementTriggers;
import com.momosoftworks.coldsweat.core.init.ModArmorMaterials;
import com.momosoftworks.coldsweat.core.init.ModAttributes;
import com.momosoftworks.coldsweat.core.init.ModBiomeModifiers;
import com.momosoftworks.coldsweat.core.init.ModBlockEntities;
import com.momosoftworks.coldsweat.core.init.ModBlocks;
import com.momosoftworks.coldsweat.core.init.ModCommands;
import com.momosoftworks.coldsweat.core.init.ModCreativeTabs;
import com.momosoftworks.coldsweat.core.init.ModEffects;
import com.momosoftworks.coldsweat.core.init.ModEntities;
import com.momosoftworks.coldsweat.core.init.ModFeatures;
import com.momosoftworks.coldsweat.core.init.ModItemComponents;
import com.momosoftworks.coldsweat.core.init.ModItems;
import com.momosoftworks.coldsweat.core.init.ModMenus;
import com.momosoftworks.coldsweat.core.init.ModParticleTypes;
import com.momosoftworks.coldsweat.core.init.ModPotions;
import com.momosoftworks.coldsweat.core.init.ModSounds;
import com.momosoftworks.coldsweat.data.ModRegistries;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="cold_sweat")
public class ColdSweat {
    public static final Logger LOGGER = LogManager.getLogger((String)"Cold Sweat");
    public static final String MOD_ID = "cold_sweat";

    public ColdSweat(IEventBus bus, ModContainer modContainer) {
        bus.addListener(this::commonSetup);
        bus.addListener(this::spawnPlacements);
        bus.addListener(this::registerCaps);
        bus.addListener(this::updateConfigs);
        ModBlocks.BLOCKS.register(bus);
        ModItems.ITEMS.register(bus);
        ModEntities.ENTITY_TYPES.register(bus);
        ModBlockEntities.BLOCK_ENTITY_TYPES.register(bus);
        ModMenus.MENU_TYPES.register(bus);
        ModEffects.EFFECTS.register(bus);
        ModParticleTypes.PARTICLES.register(bus);
        ModPotions.POTIONS.register(bus);
        ModSounds.SOUNDS.register(bus);
        ModFeatures.FEATURES.register(bus);
        ModBiomeModifiers.BIOME_MODIFIER_SERIALIZERS.register(bus);
        ModCreativeTabs.ITEM_GROUPS.register(bus);
        ModAttributes.ATTRIBUTES.register(bus);
        ModCommands.ARGUMENTS.register(bus);
        ModArmorMaterials.ARMOR_MATERIALS.register(bus);
        ModAdvancementTriggers.TRIGGERS.register(bus);
        ModItemComponents.DATA_COMPONENTS.register(bus);
        ModUpdater.updateFileNames();
        WorldSettingsConfig.setup(modContainer);
        ItemSettingsConfig.setup(modContainer);
        MainSettingsConfig.setup(modContainer);
        ClientSettingsConfig.setup(modContainer);
        EntitySettingsConfig.setup(modContainer);
        CompatManager.registerEventHandlers();
        bus.addListener(event -> {
            for (ModRegistries.RegistryHolder<?> holder : ModRegistries.getRegistries().values()) {
                event.dataPackRegistry(holder.registry(), holder.codec());
            }
        });
    }

    public static String getVersion() {
        return FMLLoader.getLoadingModList().getModFileById(MOD_ID).versionString();
    }

    public void commonSetup(FMLCommonSetupEvent event) {
    }

    public void spawnPlacements(RegisterSpawnPlacementsEvent event) {
        event.register((EntityType)ModEntities.CHAMELEON.value(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Chameleon::canSpawn, RegisterSpawnPlacementsEvent.Operation.REPLACE);
    }

    public void registerCaps(RegisterCapabilitiesEvent event) {
        event.registerEntity(ModCapabilities.PLAYER_TEMPERATURE, EntityType.PLAYER, (entity, context) -> new PlayerTempCap((LivingEntity)entity));
        for (EntityType type : BuiltInRegistries.ENTITY_TYPE) {
            event.registerEntity(ModCapabilities.ENTITY_TEMPERATURE, type, (entity, context) -> {
                if (EntityTempManager.isTemperatureEnabled(entity) && entity instanceof LivingEntity) {
                    LivingEntity living = (LivingEntity)entity;
                    return new EntityTempCap(living);
                }
                return null;
            });
        }
        event.registerEntity(ModCapabilities.SHEARABLE_FUR, EntityType.GOAT, (entity, context) -> new ShearableFurCap((LivingEntity)entity));
        for (BlockEntityType blockEntityType : List.of((BlockEntityType)ModBlockEntities.HEARTH.value(), (BlockEntityType)ModBlockEntities.BOILER.value(), (BlockEntityType)ModBlockEntities.ICEBOX.value())) {
            event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, blockEntityType, (hearthLike, facing) -> hearthLike.isHeatingSide((Direction)facing) ? new HearthBlockEntity.HotFluidHandler((HearthBlockEntity)((Object)hearthLike)) : (hearthLike.isCoolingSide((Direction)facing) ? new HearthBlockEntity.ColdFluidHandler((HearthBlockEntity)((Object)hearthLike)) : null));
        }
    }

    public void updateConfigs(FMLLoadCompleteEvent event) {
        ModUpdater.updateConfigs();
    }
}

