/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.quack.collection.redblack;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.covers1624.quack.collection.redblack.ComparableRedBlackTree;
import net.covers1624.quack.collection.redblack.ContainerNode;
import net.covers1624.quack.util.Object2IntFunction;
import net.covers1624.quack.util.SneakyUtils;
import org.jetbrains.annotations.Nullable;

public abstract class SimpleRedBlackTree<T extends Comparable<T>, N extends ContainerNode<T, N>>
extends ComparableRedBlackTree<T, N>
implements Collection<T> {
    @Override
    protected T getValue(N node) {
        return ((ContainerNode)node).value;
    }

    @Nullable
    public N find(T value) {
        return (N)((ContainerNode)this.find((T)((Object2IntFunction<ContainerNode>)n -> value.compareTo(n.value))));
    }

    public void buildFromValues(List<T> list) {
        this.buildFrom(list.stream().map(this::newNode).collect(Collectors.toList()));
    }

    @Override
    public boolean contains(Object o) {
        if (!(o instanceof Comparable)) {
            return false;
        }
        return this.find((Comparable)SneakyUtils.unsafeCast(o)) != null;
    }

    @Override
    public boolean add(T t) {
        return this.entries().add(this.newNode(t));
    }

    @Override
    public boolean remove(Object o) {
        if (!(o instanceof Comparable)) {
            return false;
        }
        return this.entries().remove(this.find((Comparable)SneakyUtils.unsafeCast(o)));
    }
}

