/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.render.shader;

import codechicken.lib.render.shader.AssetShaderObject;
import codechicken.lib.render.shader.BinaryShaderObject;
import codechicken.lib.render.shader.BinaryType;
import codechicken.lib.render.shader.ConstantCache;
import codechicken.lib.render.shader.ShaderObject;
import codechicken.lib.render.shader.ShaderProgram;
import codechicken.lib.render.shader.SimpleShaderObject;
import codechicken.lib.render.shader.UniformPair;
import codechicken.lib.render.shader.UniformType;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import net.covers1624.quack.util.SneakyUtils;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class ShaderProgramBuilder {
    private final Map<String, ShaderObject> shaders = new HashMap<String, ShaderObject>();
    private final Map<String, UniformPair> allUniforms = new HashMap<String, UniformPair>();
    @Nullable
    private Runnable applyCallback;

    private ShaderProgramBuilder() {
    }

    public static ShaderProgramBuilder builder() {
        return new ShaderProgramBuilder();
    }

    public ShaderProgramBuilder addBinaryShader(String name, Consumer<BinaryShaderObjectBuilder> func) {
        BinaryShaderObjectBuilder builder = new BinaryShaderObjectBuilder(name);
        func.accept(builder);
        return this.addShader(builder.build());
    }

    public ShaderProgramBuilder addShader(String name, Consumer<ShaderObjectBuilder> func) {
        ShaderObjectBuilder builder = new ShaderObjectBuilder(name);
        func.accept(builder);
        return this.addShader(builder.build());
    }

    public ShaderProgramBuilder addShader(ShaderObject shader) {
        if (this.shaders.containsKey(shader.getName())) {
            throw new IllegalArgumentException("Duplicate shader with name: " + shader.getName());
        }
        this.shaders.put(shader.getName(), shader);
        return this;
    }

    public ShaderProgramBuilder whenUsed(Runnable callback) {
        this.applyCallback = this.applyCallback == null ? callback : SneakyUtils.concat(this.applyCallback, callback);
        return this;
    }

    public ShaderProgram build() {
        return new ShaderProgram(this.shaders.values(), this.allUniforms.values(), this.applyCallback);
    }

    public class BinaryShaderObjectBuilder
    extends ShaderObjectBuilder {
        @Nullable
        private BinaryType binaryType;
        @Nullable
        private String entryPoint;
        private Consumer<ConstantCache> specializationCallback;

        private BinaryShaderObjectBuilder(String name) {
            super(name);
            this.specializationCallback = SneakyUtils.nullCons();
        }

        @Override
        public BinaryShaderObjectBuilder source(String source) {
            throw new IllegalStateException("Binary shaders don't have string source.");
        }

        @Override
        public BinaryShaderObjectBuilder source(ResourceLocation asset) {
            return (BinaryShaderObjectBuilder)super.source(asset);
        }

        @Override
        public BinaryShaderObjectBuilder uniform(String name, UniformType type) {
            return (BinaryShaderObjectBuilder)super.uniform(name, type);
        }

        public BinaryShaderObjectBuilder binaryType(BinaryType binaryType) {
            if (this.binaryType != null) {
                throw new IllegalStateException("Binary type already set.");
            }
            this.binaryType = binaryType;
            return this;
        }

        public BinaryShaderObjectBuilder entryPoint(String entryPoint) {
            if (this.entryPoint != null) {
                throw new IllegalStateException("Entry point already set.");
            }
            this.entryPoint = entryPoint;
            return this;
        }

        public BinaryShaderObjectBuilder whenSpecialized(Consumer<ConstantCache> specializationCallback) {
            this.specializationCallback = specializationCallback;
            return this;
        }

        @Override
        protected ShaderObject build() {
            if (this.type == null) {
                throw new IllegalStateException("Type not set.");
            }
            if (this.assetSource == null) {
                throw new IllegalStateException("AssetSource not set.");
            }
            if (this.binaryType == null) {
                throw new IllegalStateException("Binary type not set");
            }
            if (this.entryPoint == null || this.entryPoint.isEmpty()) {
                throw new IllegalStateException("Entry point not set.");
            }
            return new BinaryShaderObject(this.name, this.assetSource, this.type, this.binaryType, this.entryPoint, ShaderProgramBuilder.this.allUniforms.values(), this.specializationCallback);
        }
    }

    public class ShaderObjectBuilder {
        protected final String name;
        protected final Map<String, UniformPair> uniforms = new HashMap<String, UniformPair>();
        @Nullable
        protected ShaderObject.ShaderType type;
        @Nullable
        protected String simpleSource;
        @Nullable
        protected ResourceLocation assetSource;

        private ShaderObjectBuilder(String name) {
            this.name = Objects.requireNonNull(name);
        }

        public ShaderObjectBuilder type(ShaderObject.ShaderType type) {
            if (this.type != null) {
                throw new IllegalArgumentException("Type already set.");
            }
            this.type = Objects.requireNonNull(type);
            return this;
        }

        public ShaderObjectBuilder source(String source) {
            if (this.simpleSource != null || this.assetSource != null) {
                throw new IllegalArgumentException("Source already set.");
            }
            this.simpleSource = Objects.requireNonNull(source);
            return this;
        }

        public ShaderObjectBuilder source(ResourceLocation asset) {
            if (this.assetSource != null || this.simpleSource != null) {
                throw new IllegalArgumentException("Source already set.");
            }
            this.assetSource = Objects.requireNonNull(asset);
            return this;
        }

        public ShaderObjectBuilder uniform(String name, UniformType type) {
            UniformPair uniform = ShaderProgramBuilder.this.allUniforms.get(name);
            if (uniform != null && uniform.type() != type) {
                throw new IllegalArgumentException("Uniform with name '" + name + "' already exists with a different type: " + String.valueOf((Object)uniform.type()));
            }
            if (uniform == null) {
                uniform = new UniformPair(name, type);
                ShaderProgramBuilder.this.allUniforms.put(name, uniform);
            }
            this.uniforms.put(name, uniform);
            return this;
        }

        protected ShaderObject build() {
            if (this.type == null) {
                throw new IllegalStateException("Type not set.");
            }
            if (this.simpleSource == null && this.assetSource == null) {
                throw new IllegalStateException("SimpleSource or AssetSource not set.");
            }
            if (this.simpleSource != null) {
                return new SimpleShaderObject(this.name, this.type, this.uniforms.values(), this.simpleSource);
            }
            return new AssetShaderObject(this.name, this.type, this.uniforms.values(), this.assetSource);
        }
    }
}

