/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.render.lighting;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.lighting.PlanarLightModel;
import codechicken.lib.render.pipeline.IVertexOperation;
import java.util.Objects;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import org.jetbrains.annotations.Nullable;

public class PlanarLightMatrix
extends PlanarLightModel {
    public static final int operationIndex = IVertexOperation.registerOperation();
    public static PlanarLightMatrix instance = new PlanarLightMatrix();
    @Nullable
    public BlockAndTintGetter access;
    public BlockPos pos = BlockPos.ZERO;
    private int sampled = 0;
    public int[] brightness = new int[6];

    public PlanarLightMatrix() {
        super(PlanarLightModel.standardLightModel.colours);
    }

    public PlanarLightMatrix locate(BlockAndTintGetter a, BlockPos bPos) {
        this.access = a;
        this.pos = bPos;
        this.sampled = 0;
        return this;
    }

    public int brightness(int side) {
        Objects.requireNonNull(this.access, "PlanarLightMatrix must be located first.");
        if ((this.sampled & 1 << side) == 0) {
            this.brightness[side] = LevelRenderer.getLightColor((BlockAndTintGetter)this.access, (BlockPos)this.pos);
            this.sampled |= 1 << side;
        }
        return this.brightness[side];
    }

    @Override
    public boolean load(CCRenderState ccrs) {
        ccrs.pipeline.addDependency(ccrs.sideAttrib);
        return true;
    }

    @Override
    public void operate(CCRenderState ccrs) {
        super.operate(ccrs);
        ccrs.brightness = this.brightness(ccrs.side);
    }

    @Override
    public int operationID() {
        return operationIndex;
    }
}

