/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.render.block;

import codechicken.lib.internal.ClientInit;
import codechicken.lib.internal.ExceptionMessageEventHandler;
import codechicken.lib.render.block.BlockRenderingRegistry;
import codechicken.lib.render.block.ICCBlockRenderer;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.concurrent.TimeUnit;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CCBlockRendererDispatcher
extends BlockRenderDispatcher {
    private static final Logger logger = LogManager.getLogger();
    public final BlockRenderDispatcher parentDispatcher;
    private static long lastTime;

    public CCBlockRendererDispatcher(BlockRenderDispatcher parent, BlockColors blockColours) {
        super(parent.getBlockModelShaper(), parent.blockEntityRenderer, blockColours);
        this.parentDispatcher = parent;
        this.modelRenderer = parent.modelRenderer;
        this.liquidBlockRenderer = parent.liquidBlockRenderer;
    }

    public void renderBatched(BlockState state, BlockPos pos, BlockAndTintGetter level, PoseStack stack, VertexConsumer builder, boolean checkSides, RandomSource rand, ModelData modelData, RenderType renderType) {
        try {
            ICCBlockRenderer renderer = BlockRenderingRegistry.findFor(state.getBlock(), e -> e.canHandleBlock(level, pos, state, renderType));
            if (renderer != null) {
                renderer.renderBlock(state, pos, level, stack, builder, rand, modelData, renderType);
                return;
            }
        }
        catch (Throwable t) {
            if (ClientInit.catchBlockRenderExceptions) {
                CCBlockRendererDispatcher.handleCaughtException(t, state, pos, level);
                return;
            }
            CrashReport crashreport = CrashReport.forThrowable((Throwable)t, (String)"Tessellating CCL block in world");
            CrashReportCategory crashreportcategory = crashreport.addCategory("Block being tessellated");
            CrashReportCategory.populateBlockDetails((CrashReportCategory)crashreportcategory, (LevelHeightAccessor)level, (BlockPos)pos, (BlockState)state);
            throw new ReportedException(crashreport);
        }
        try {
            this.parentDispatcher.renderBatched(state, pos, level, stack, builder, checkSides, rand, modelData, renderType);
        }
        catch (Throwable t) {
            if (ClientInit.catchBlockRenderExceptions) {
                CCBlockRendererDispatcher.handleCaughtException(t, state, pos, level);
                return;
            }
            throw t;
        }
    }

    public void renderBreakingTexture(BlockState state, BlockPos pos, BlockAndTintGetter world, PoseStack matrixStackIn, VertexConsumer vertexBuilderIn, ModelData data) {
        ICCBlockRenderer renderer = BlockRenderingRegistry.findFor(state.getBlock(), e -> e.canHandleBlock(world, pos, state, null));
        if (renderer != null) {
            renderer.renderBreaking(state, pos, world, matrixStackIn, vertexBuilderIn, data);
        } else {
            this.parentDispatcher.renderBreakingTexture(state, pos, world, matrixStackIn, vertexBuilderIn, data);
        }
    }

    public void renderLiquid(BlockPos pos, BlockAndTintGetter world, VertexConsumer builder, BlockState blockState, FluidState fluidState) {
        ICCBlockRenderer renderer = BlockRenderingRegistry.findFor(fluidState.getType(), e -> e.canHandleFluid(world, pos, blockState, fluidState));
        if (renderer != null) {
            renderer.renderFluid(pos, world, builder, blockState, fluidState);
            return;
        }
        this.parentDispatcher.renderLiquid(pos, world, builder, blockState, fluidState);
    }

    public void renderSingleBlock(BlockState blockStateIn, PoseStack matrixStackIn, MultiBufferSource bufferTypeIn, int combinedLightIn, int combinedOverlayIn, ModelData modelData, RenderType renderType) {
        ICCBlockRenderer renderer = BlockRenderingRegistry.findFor(blockStateIn.getBlock(), e -> e.canHandleEntity(blockStateIn));
        if (renderer != null) {
            renderer.renderEntity(blockStateIn, matrixStackIn, bufferTypeIn, combinedLightIn, combinedOverlayIn, modelData, renderType);
        } else {
            this.parentDispatcher.renderSingleBlock(blockStateIn, matrixStackIn, bufferTypeIn, combinedLightIn, combinedOverlayIn, modelData, renderType);
        }
    }

    private static void handleCaughtException(Throwable t, BlockState inState, BlockPos pos, BlockAndTintGetter world) {
        long time;
        Block inBlock = inState.getBlock();
        BlockEntity tile = world.getBlockEntity(pos);
        StringBuilder builder = new StringBuilder("\n CCL has caught an exception whilst rendering a block\n");
        builder.append("  BlockPos:      ").append(String.format("x:%s, y:%s, z:%s", pos.getX(), pos.getY(), pos.getZ())).append("\n");
        builder.append("  Block Class:   ").append(inBlock.getClass()).append("\n");
        builder.append("  Registry Name: ").append(BuiltInRegistries.BLOCK.getKey((Object)inBlock)).append("\n");
        builder.append("  State:         ").append(inState).append("\n");
        builder.append(" Tile at position\n");
        builder.append("  Tile Class:    ").append(tile != null ? tile.getClass() : null).append("\n");
        builder.append("  Tile Id:       ").append(tile != null ? BuiltInRegistries.BLOCK_ENTITY_TYPE.getKey((Object)tile.getType()) : null).append("\n");
        builder.append("  Tile NBT:      ").append(tile != null ? tile.saveWithoutMetadata((HolderLookup.Provider)tile.getLevel().registryAccess()) : null).append("\n");
        builder.append("This functionality can be disabled in the CCL config file.\n");
        if (ClientInit.messagePlayerOnRenderExceptionCaught) {
            builder.append("You can also turn off player messages in the CCL config file.\n");
        }
        String logMessage = builder.toString();
        String key = ExceptionUtils.getStackTrace((Throwable)t) + logMessage;
        if (ExceptionMessageEventHandler.exceptionMessageCache.add(key)) {
            logger.error(logMessage, t);
        }
        LocalPlayer player = Minecraft.getInstance().player;
        if (ClientInit.messagePlayerOnRenderExceptionCaught && player != null && TimeUnit.NANOSECONDS.toSeconds((time = System.nanoTime()) - lastTime) > 5L) {
            lastTime = time;
            player.sendSystemMessage((Component)Component.literal((String)"CCL Caught an exception rendering a block. See the log for info."));
        }
    }
}

