/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.render;

import codechicken.lib.colour.Colour;
import codechicken.lib.colour.ColourRGBA;
import codechicken.lib.model.CachedFormat;
import codechicken.lib.render.buffer.ISpriteAwareVertexConsumer;
import codechicken.lib.render.buffer.TransformingVertexConsumer;
import codechicken.lib.render.lighting.LC;
import codechicken.lib.render.lighting.LightMatrix;
import codechicken.lib.render.pipeline.CCRenderPipeline;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.render.pipeline.IVertexSource;
import codechicken.lib.render.pipeline.VertexAttribute;
import codechicken.lib.render.pipeline.attribute.ColourAttribute;
import codechicken.lib.render.pipeline.attribute.LightCoordAttribute;
import codechicken.lib.render.pipeline.attribute.LightingAttribute;
import codechicken.lib.render.pipeline.attribute.NormalAttribute;
import codechicken.lib.render.pipeline.attribute.SideAttribute;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Vector3;
import codechicken.lib.vec.Vertex5;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

public class CCRenderState {
    private static final ThreadLocal<CCRenderState> instances = ThreadLocal.withInitial(CCRenderState::new);
    public final VertexAttribute<Vector3[]> normalAttrib = new NormalAttribute();
    public final VertexAttribute<int[]> colourAttrib = new ColourAttribute();
    public final VertexAttribute<int[]> lightingAttrib = new LightingAttribute();
    public final VertexAttribute<int[]> sideAttrib = new SideAttribute();
    public final VertexAttribute<LC[]> lightCoordAttrib = new LightCoordAttribute();
    @Nullable
    public IVertexSource model;
    public int firstVertexIndex;
    public int lastVertexIndex;
    public int vertexIndex;
    public CCRenderPipeline pipeline;
    @Nullable
    public VertexConsumer r;
    @Nullable
    public VertexFormat fmt;
    @Nullable
    public CachedFormat cFmt;
    public int baseColour;
    public int alphaOverride;
    public boolean computeLighting;
    public LightMatrix lightMatrix = new LightMatrix();
    public final Vertex5 vert = new Vertex5();
    public final Vector3 normal = new Vector3();
    public int colour;
    public int brightness;
    public int overlay;
    public int side;
    public LC lc = new LC();
    @Nullable
    public TextureAtlasSprite sprite;

    private CCRenderState() {
        this.pipeline = new CCRenderPipeline(this);
    }

    public static CCRenderState instance() {
        return instances.get();
    }

    public void bind(BufferBuilder r) {
        this.bind((VertexConsumer)r, r.format);
    }

    public void bind(VertexConsumer consumer, VertexFormat format) {
        this.r = consumer;
        this.fmt = format;
        this.cFmt = CachedFormat.lookup(format);
    }

    public void bind(RenderType renderType, MultiBufferSource source) {
        this.bind(source.getBuffer(renderType), renderType.format());
    }

    public void bind(RenderType renderType, MultiBufferSource source, PoseStack mStack) {
        this.bind(new TransformingVertexConsumer(source.getBuffer(renderType), mStack), renderType.format());
    }

    public void bind(RenderType renderType, MultiBufferSource getter, Matrix4 mat) {
        this.bind(new TransformingVertexConsumer(getter.getBuffer(renderType), mat), renderType.format());
    }

    public void reset() {
        this.model = null;
        this.pipeline.reset();
        this.computeLighting = true;
        this.alphaOverride = -1;
        this.baseColour = -1;
        this.colour = -1;
    }

    public void preRenderWorld(BlockAndTintGetter world, BlockPos pos) {
        this.reset();
        this.colour = -1;
        this.setBrightness(world, pos);
    }

    public void setPipeline(IVertexOperation ... ops) {
        this.pipeline.setPipeline(ops);
    }

    public void setPipeline(IVertexSource model, int start, int end, IVertexOperation ... ops) {
        this.pipeline.reset();
        this.setModel(model, start, end);
        this.pipeline.setPipeline(ops);
    }

    public void bindModel(IVertexSource model) {
        if (this.model != model) {
            this.model = model;
            this.pipeline.rebuild();
        }
    }

    public void setModel(IVertexSource source) {
        this.setModel(source, 0, source.getVertexCount());
    }

    public void setModel(IVertexSource source, int start, int end) {
        this.bindModel(source);
        this.setVertexRange(start, end);
    }

    public void setVertexRange(int start, int end) {
        this.firstVertexIndex = start;
        this.lastVertexIndex = end;
    }

    public void render(IVertexOperation ... ops) {
        this.setPipeline(ops);
        this.render();
    }

    public void render() {
        if (this.r == null) {
            throw new IllegalStateException("VertexConsumer is not bound.");
        }
        if (this.fmt == null) {
            throw new IllegalStateException("VertexFormat is not bound?");
        }
        if (this.model == null) {
            throw new IllegalStateException("Model is not set.");
        }
        Vertex5[] verts = this.model.getVertices();
        this.vertexIndex = this.firstVertexIndex;
        while (this.vertexIndex < this.lastVertexIndex) {
            this.model.prepareVertex(this);
            this.vert.set(verts[this.vertexIndex]);
            this.runPipeline();
            this.writeVert();
            ++this.vertexIndex;
        }
    }

    public void runPipeline() {
        this.pipeline.operate();
    }

    public void writeVert() {
        Object object;
        assert (this.r != null);
        assert (this.fmt != null);
        assert (this.cFmt != null);
        if (this.sprite != null && (object = this.r) instanceof ISpriteAwareVertexConsumer) {
            ISpriteAwareVertexConsumer cons = (ISpriteAwareVertexConsumer)object;
            cons.sprite(this.sprite);
        }
        List elements = this.fmt.getElements();
        block11: for (VertexFormatElement fmte : elements) {
            switch (fmte.usage()) {
                case POSITION: {
                    this.r.addVertex((float)this.vert.vec.x, (float)this.vert.vec.y, (float)this.vert.vec.z);
                    continue block11;
                }
                case UV: {
                    switch (fmte.index()) {
                        case 0: {
                            this.r.setUv((float)this.vert.uv.u, (float)this.vert.uv.v);
                            continue block11;
                        }
                        case 1: {
                            this.r.setOverlay(this.overlay);
                            continue block11;
                        }
                        case 2: {
                            this.r.setLight(this.brightness);
                            continue block11;
                        }
                    }
                    throw new UnsupportedOperationException("Unknown UV index. " + fmte.index());
                }
                case COLOR: {
                    this.r.setColor(this.colour >>> 24, this.colour >> 16 & 0xFF, this.colour >> 8 & 0xFF, this.alphaOverride >= 0 ? this.alphaOverride : this.colour & 0xFF);
                    continue block11;
                }
                case NORMAL: {
                    this.r.setNormal((float)this.normal.x, (float)this.normal.y, (float)this.normal.z);
                    continue block11;
                }
            }
            throw new UnsupportedOperationException("Generic vertex format element");
        }
    }

    public void setBrightness(BlockAndTintGetter world, BlockPos pos) {
        this.brightness = LevelRenderer.getLightColor((BlockAndTintGetter)world, (BlockState)world.getBlockState(pos), (BlockPos)pos);
    }

    public void setBrightness(Entity entity, float frameDelta) {
        this.brightness = Minecraft.getInstance().getEntityRenderDispatcher().getPackedLightCoords(entity, frameDelta);
    }

    public void setFluidColour(FluidStack fluidStack) {
        this.setFluidColour(fluidStack, 255);
    }

    public void setFluidColour(FluidStack fluidStack, int alpha) {
        this.baseColour = IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid()).getTintColor(fluidStack) << 8 | alpha;
    }

    public void setColour(Colour colour) {
        this.colour = colour.rgba();
    }

    public ColourRGBA getColour() {
        return new ColourRGBA(this.colour);
    }

    public VertexConsumer getConsumer() {
        return Objects.requireNonNull(this.r, "VertexConsumer is not bound.");
    }

    public VertexFormat getVertexFormat() {
        return Objects.requireNonNull(this.fmt, "VertexFormat is not bound.");
    }
}

