/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.internal.command.client;

import codechicken.lib.internal.ItemFileRenderer;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;

public class RenderItemToFileCommand {
    private static final DynamicCommandExceptionType ERROR_INVALID = new DynamicCommandExceptionType(p_311534_ -> (Component)p_311534_);

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"ccl").then(((LiteralArgumentBuilder)Commands.literal((String)"render_held").then(Commands.argument((String)"resolution", (ArgumentType)IntegerArgumentType.integer((int)16)).then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.greedyString()).executes(e -> RenderItemToFileCommand.renderToFile((CommandContext<CommandSourceStack>)e, RenderItemToFileCommand.getResolution((CommandContext<CommandSourceStack>)e)))))).then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.greedyString()).executes(e -> RenderItemToFileCommand.renderToFile((CommandContext<CommandSourceStack>)e, 512))))).then(Commands.literal((String)"render_held_anim").then(Commands.argument((String)"fps", (ArgumentType)IntegerArgumentType.integer((int)5, (int)75)).then(((RequiredArgumentBuilder)Commands.argument((String)"duration", (ArgumentType)IntegerArgumentType.integer()).then(Commands.argument((String)"resolution", (ArgumentType)IntegerArgumentType.integer((int)16)).then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.greedyString()).executes(e -> RenderItemToFileCommand.renderAnim((CommandContext<CommandSourceStack>)e, RenderItemToFileCommand.getResolution((CommandContext<CommandSourceStack>)e)))))).then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.greedyString()).executes(e -> RenderItemToFileCommand.renderAnim((CommandContext<CommandSourceStack>)e, 512)))))));
    }

    private static int renderToFile(CommandContext<CommandSourceStack> ctx, int resolution) throws CommandSyntaxException {
        String path = RenderItemToFileCommand.getPath(ctx);
        ItemStack held = RenderItemToFileCommand.getHeldItem();
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)("Queued item render to file: " + path)), false);
        ItemFileRenderer.renderStatic(held, path, resolution);
        return 0;
    }

    private static int renderAnim(CommandContext<CommandSourceStack> ctx, int resolution) throws CommandSyntaxException {
        Object finalPath;
        String ext;
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        int fps = IntegerArgumentType.getInteger(ctx, (String)"fps");
        int duration = IntegerArgumentType.getInteger(ctx, (String)"duration");
        String path = RenderItemToFileCommand.getPath(ctx);
        ItemStack held = RenderItemToFileCommand.getHeldItem();
        int lastSlash = path.lastIndexOf(47);
        int lastDot = path.lastIndexOf(46, lastSlash != -1 ? lastSlash : path.length() - 1);
        String string = ext = lastDot != -1 ? path.substring(lastDot + 1) : "";
        if (ext.isEmpty()) {
            ext = "gif";
            finalPath = path + ".gif";
        } else {
            finalPath = path;
        }
        switch (ext) {
            case "gif": {
                ItemFileRenderer.addGifRenderTask(held, (String)finalPath, resolution, fps, duration);
                src.sendSuccess(() -> RenderItemToFileCommand.lambda$renderAnim$6((String)finalPath), false);
                break;
            }
            case "webp": {
                if (!ItemFileRenderer.addWebpRenderTask(held, path, resolution, fps, duration)) {
                    src.sendFailure((Component)Component.literal((String)"Failed to queue render for webp, ffmpeg is not accessible. Either make it accessible on PATH, or set the `ccl.ffmpeg` system property."));
                    break;
                }
                src.sendSuccess(() -> Component.literal((String)("Queued item render to webp: " + path)), false);
            }
        }
        return 0;
    }

    private static String getPath(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        String str = StringArgumentType.getString(ctx, (String)"name");
        if (str.contains("..")) {
            throw ERROR_INVALID.create((Object)Component.literal((String)"'..' is not allowed in name."));
        }
        return str;
    }

    public static int getResolution(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        int res = IntegerArgumentType.getInteger(ctx, (String)"resolution");
        if ((res & res - 1) != 0) {
            throw ERROR_INVALID.create((Object)Component.literal((String)"Resolution must be a power of 2. 16, 32, 64..."));
        }
        return res;
    }

    private static ItemStack getHeldItem() throws CommandSyntaxException {
        LocalPlayer player = Objects.requireNonNull(Minecraft.getInstance().player);
        ItemStack held = player.getItemInHand(InteractionHand.MAIN_HAND);
        if (held.isEmpty()) {
            held = player.getItemInHand(InteractionHand.OFF_HAND);
        }
        if (held.isEmpty()) {
            throw ERROR_INVALID.create((Object)Component.literal((String)"You are not holding anything."));
        }
        return held;
    }

    private static /* synthetic */ Component lambda$renderAnim$6(String finalPath) {
        return Component.literal((String)("Queued item render to gif: " + finalPath));
    }
}

