/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.internal.command.admin;

import codechicken.lib.math.MathHelper;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.function.Predicate;
import java.util.stream.StreamSupport;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;

public class CountCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext context) {
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"ccl").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"count").requires(e -> e.hasPermission(2))).then(Commands.argument((String)"entity", (ArgumentType)ResourceArgument.resource((CommandBuildContext)context, (ResourceKey)Registries.ENTITY_TYPE)).executes(ctx -> {
            EntityType entityType = (EntityType)ResourceArgument.getEntityType((CommandContext)ctx, (String)"entity").value();
            return CountCommand.countAllEntities((CommandContext<CommandSourceStack>)ctx, e -> e.equals(entityType));
        }))).executes(ctx -> CountCommand.countAllEntities((CommandContext<CommandSourceStack>)ctx, e -> true))));
    }

    private static int countAllEntities(CommandContext<CommandSourceStack> ctx, Predicate<EntityType<?>> predicate) {
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        ServerLevel level = source.getLevel();
        ServerChunkCache chunkCache = level.getChunkSource();
        Object2IntOpenHashMap counts = new Object2IntOpenHashMap();
        counts.defaultReturnValue(0);
        StreamSupport.stream(level.getEntities().getAll().spliterator(), false).filter(e -> predicate.test(e.getType())).filter(e -> chunkCache.hasChunk(MathHelper.floor(e.getX()) >> 4, MathHelper.floor(e.getZ()) >> 4)).forEach(arg_0 -> CountCommand.lambda$countAllEntities$7((Object2IntMap)counts, arg_0));
        ArrayList<EntityType> order = new ArrayList<EntityType>((Collection<EntityType>)counts.keySet());
        order.sort(Comparator.comparingInt(arg_0 -> ((Object2IntMap)counts).getInt(arg_0)));
        int total = 0;
        for (EntityType type : order) {
            int count = counts.getInt((Object)type);
            String name = BuiltInRegistries.ENTITY_TYPE.getKey((Object)type).toString();
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)(String.valueOf(ChatFormatting.GREEN) + name + String.valueOf(ChatFormatting.RESET) + " x " + String.valueOf(ChatFormatting.AQUA) + count)), false);
            total += count;
        }
        if (order.isEmpty()) {
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"ccl.commands.count.fail"), false);
        } else if (order.size() > 1) {
            int finalTotal = total;
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"ccl.commands.count.total", (Object[])new Object[]{ChatFormatting.AQUA.toString() + finalTotal + String.valueOf(ChatFormatting.RESET)}), false);
        }
        return total;
    }

    private static /* synthetic */ void lambda$countAllEntities$7(Object2IntMap counts, Entity e) {
        int count = counts.getInt((Object)e.getType());
        counts.put((Object)e.getType(), count + 1);
    }
}

