/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.gui.modular.elements;

import codechicken.lib.colour.ColourARGB;
import codechicken.lib.gui.modular.ModularGui;
import codechicken.lib.gui.modular.elements.GuiRectangle;
import codechicken.lib.gui.modular.lib.BackgroundRender;
import codechicken.lib.gui.modular.lib.Constraints;
import codechicken.lib.gui.modular.lib.ElementEvents;
import codechicken.lib.gui.modular.lib.ForegroundRender;
import codechicken.lib.gui.modular.lib.GuiRender;
import codechicken.lib.gui.modular.lib.TooltipHandler;
import codechicken.lib.gui.modular.lib.geometry.ConstrainedGeometry;
import codechicken.lib.gui.modular.lib.geometry.GuiParent;
import codechicken.lib.gui.modular.lib.geometry.Position;
import codechicken.lib.gui.modular.lib.geometry.Rectangle;
import com.google.common.collect.Lists;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.covers1624.quack.util.SneakyUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuiElement<T extends GuiElement<T>>
extends ConstrainedGeometry<T>
implements ElementEvents,
TooltipHandler<T> {
    @NotNull
    private GuiParent<?> parent;
    private final List<GuiElement<?>> addedQueue = new ArrayList();
    private final List<GuiElement<?>> removeQueue = new ArrayList();
    private final List<GuiElement<?>> childElements = new ArrayList();
    private final List<GuiElement<?>> childElementsUnmodifiable = Collections.unmodifiableList(this.childElements);
    private final Map<GuiElement<?>, Integer> reorderMap = new HashMap();
    public boolean initialized = false;
    private Minecraft mc;
    private Font font;
    private int screenWidth;
    private int screenHeight;
    protected int hoverTime = 0;
    private int hoverTextDelay = 10;
    private boolean isMouseOver = false;
    private boolean opaque = false;
    private boolean removed = true;
    private boolean zStacking = true;
    private Supplier<Boolean> enabled = () -> true;
    private Supplier<Boolean> enableToolTip = () -> true;
    private Supplier<List<Component>> toolTip = null;
    private Rectangle renderCull = Rectangle.create(Position.create(0.0, 0.0), () -> this.screenWidth, () -> this.screenHeight);
    private Consumer<ItemStack> jeiDropConsumer = null;
    private boolean isJeiExcluded = false;

    public GuiElement(@NotNull GuiParent<?> parent) {
        this.parent = parent;
        this.parent.addChild(this);
    }

    @Override
    @NotNull
    public GuiParent<?> getParent() {
        return this.parent;
    }

    @Override
    public List<GuiElement<?>> getChildren() {
        return this.childElementsUnmodifiable;
    }

    @Override
    public void addChild(GuiElement<?> child) {
        if (!this.initialized) {
            throw new IllegalStateException("Attempted to add a child to an element before that element has been initialised!");
        }
        if (child == this) {
            throw new InvalidParameterException("Attempted to add element to itself as a child element.");
        }
        if (child.getParent() != this) {
            throw new UnsupportedOperationException("Attempted to add an already initialized element to a different parent element.");
        }
        if (this.removeQueue.contains(child)) {
            this.removeQueue.remove(child);
            if (!this.childElements.contains(child)) {
                this.addedQueue.add(child);
            }
            child.initElement(this);
        } else if (!this.childElements.contains(child)) {
            this.addedQueue.add(child);
            child.initElement(this);
        }
    }

    protected void applyQueuedChildUpdates() {
        if (!this.reorderMap.isEmpty()) {
            this.reorderMap.forEach((element, index) -> {
                if (!this.childElements.contains(element)) {
                    return;
                }
                this.childElements.remove(element);
                this.childElements.add(Math.min(index, this.childElements.size()), (GuiElement<?>)element);
            });
            this.reorderMap.clear();
        }
        if (!this.removeQueue.isEmpty()) {
            this.childElements.removeAll(this.removeQueue);
            this.removeQueue.clear();
        }
        if (!this.addedQueue.isEmpty()) {
            this.childElements.addAll(this.addedQueue);
            this.addedQueue.forEach(ConstrainedGeometry::clearGeometryCache);
            this.addedQueue.clear();
        }
    }

    public void initElement(GuiParent<?> parent) {
        this.removed = false;
        this.updateScreenData(parent.mc(), parent.font(), parent.scaledScreenWidth(), parent.scaledScreenHeight());
        this.initialized = true;
    }

    @Override
    public void adoptChild(GuiElement<?> child) {
        child.getParent().removeChild(child);
        child.parent = this;
        this.addChild(child);
    }

    @Override
    public void removeChild(GuiElement<?> child) {
        if (this.childElements.contains(child)) {
            child.removed = true;
            this.removeQueue.add(child);
        }
        this.addedQueue.remove(child);
    }

    public void bringChildToForeground(GuiElement<?> child) {
        this.sendChildToIndex(child, this.childElements.size() - 1);
    }

    public void sendChildToIndex(GuiElement<?> child, int index) {
        this.reorderMap.put(child, index);
    }

    public void sendChildToBackground(GuiElement<?> child) {
        this.sendChildToIndex(child, 0);
    }

    @Override
    public boolean isDescendantOf(GuiElement<?> ancestor) {
        return ancestor == this.parent || this.parent.isDescendantOf(ancestor);
    }

    @Override
    public Minecraft mc() {
        return this.mc;
    }

    @Override
    public Font font() {
        return this.font;
    }

    @Override
    public int scaledScreenWidth() {
        return this.screenWidth;
    }

    @Override
    public int scaledScreenHeight() {
        return this.screenHeight;
    }

    @Override
    public ModularGui getModularGui() {
        return this.getParent().getModularGui();
    }

    @Override
    public void onScreenInit(Minecraft mc, Font font, int screenWidth, int screenHeight) {
        this.updateScreenData(mc, font, screenWidth, screenHeight);
        super.onScreenInit(mc, font, screenWidth, screenHeight);
    }

    protected void updateScreenData(Minecraft mc, Font font, int screenWidth, int screenHeight) {
        this.mc = mc;
        this.font = font;
        this.screenWidth = screenWidth;
        this.screenHeight = screenHeight;
    }

    public T setEnabled(boolean enabled) {
        this.enabled = () -> enabled;
        return (T)((GuiElement)SneakyUtils.unsafeCast(this));
    }

    public T setEnabled(@Nullable Supplier<Boolean> enabled) {
        this.enabled = enabled;
        return (T)((GuiElement)SneakyUtils.unsafeCast(this));
    }

    public boolean isEnabled() {
        return !this.removed && this.enabled.get() != false;
    }

    public boolean isRemoved() {
        return this.removed;
    }

    public T setEnableToolTip(Supplier<Boolean> enableToolTip) {
        this.enableToolTip = enableToolTip;
        return (T)((GuiElement)SneakyUtils.unsafeCast(this));
    }

    public boolean isTooltipEnabled() {
        return this.enableToolTip.get();
    }

    @Override
    public boolean blockMouseOver(GuiElement<?> element, double mouseX, double mouseY) {
        return this.getParent().blockMouseOver(element, mouseX, mouseY);
    }

    @Override
    public boolean blockMouseEvents() {
        return this.isMouseOver() && this.isOpaque();
    }

    public boolean isMouseOver() {
        return this.isMouseOver;
    }

    public boolean isOpaque() {
        return this.opaque;
    }

    public T setOpaque(boolean opaque) {
        this.opaque = opaque;
        return (T)((GuiElement)SneakyUtils.unsafeCast(this));
    }

    public int hoverTime() {
        return this.hoverTime;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{geometry=" + String.valueOf(this.getRectangle()) + "}";
    }

    public T setRenderCull(@Nullable Rectangle renderCull) {
        this.renderCull = renderCull;
        return (T)((GuiElement)SneakyUtils.unsafeCast(this));
    }

    public T setZStacking(boolean zStacking) {
        this.zStacking = zStacking;
        return (T)((GuiElement)SneakyUtils.unsafeCast(this));
    }

    public boolean zStacking() {
        return this.zStacking;
    }

    public double getCombinedElementDepth() {
        double depth = 0.0;
        GuiElement guiElement = this;
        if (guiElement instanceof BackgroundRender) {
            BackgroundRender bgr = (BackgroundRender)((Object)guiElement);
            depth += bgr.getBackgroundDepth();
        }
        if ((guiElement = this) instanceof ForegroundRender) {
            ForegroundRender fgr = (ForegroundRender)((Object)guiElement);
            depth += fgr.getForegroundDepth();
        }
        double childDepth = 0.0;
        for (GuiElement<?> child : this.childElements) {
            if (!child.isEnabled()) continue;
            if (this.zStacking) {
                childDepth += child.getCombinedElementDepth();
                continue;
            }
            childDepth = Math.max(childDepth, child.getCombinedElementDepth());
        }
        return depth + childDepth;
    }

    public void render(GuiRender render, double mouseX, double mouseY, float partialTicks) {
        GuiElement guiElement;
        this.applyQueuedChildUpdates();
        GuiElement guiElement2 = this;
        if (guiElement2 instanceof BackgroundRender) {
            BackgroundRender bgr = (BackgroundRender)((Object)guiElement2);
            double depth = bgr.getBackgroundDepth();
            bgr.renderBackground(render, mouseX, mouseY, partialTicks);
            if (depth > 0.0) {
                render.pose().translate(0.0, 0.0, depth);
            }
        }
        double maxDepth = 0.0;
        for (GuiElement<?> guiElement3 : this.childElements) {
            if (!guiElement3.isEnabled()) continue;
            boolean rendered = this.renderChild(guiElement3, render, mouseX, mouseY, partialTicks);
            if (this.zStacking || !rendered) continue;
            double depth = guiElement3.getCombinedElementDepth();
            maxDepth = Math.max(maxDepth, depth);
            render.pose().translate(0.0, 0.0, -depth);
        }
        if (!this.zStacking) {
            render.pose().translate(0.0, 0.0, maxDepth);
        }
        if ((guiElement = this) instanceof ForegroundRender) {
            ForegroundRender fgr = (ForegroundRender)((Object)guiElement);
            double d = fgr.getForegroundDepth();
            fgr.renderForeground(render, mouseX, mouseY, partialTicks);
            if (d > 0.0) {
                render.pose().translate(0.0, 0.0, d);
            }
        }
    }

    protected boolean renderChild(GuiElement<?> child, GuiRender render, double mouseX, double mouseY, float partialTicks) {
        if (this.renderCull != null && !this.renderCull.intersects(child.getRectangle())) {
            return false;
        }
        child.render(render, mouseX, mouseY, partialTicks);
        return true;
    }

    public boolean renderOverlay(GuiRender render, double mouseX, double mouseY, float partialTicks, boolean consumed) {
        for (GuiElement child : Lists.reverse(this.getChildren())) {
            if (!child.isEnabled()) continue;
            consumed |= child.renderOverlay(render, mouseX, mouseY, partialTicks, consumed);
        }
        return consumed || this.showToolTip() && this.renderTooltip(render, mouseX, mouseY);
    }

    public boolean showToolTip() {
        return this.isMouseOver() && this.isTooltipEnabled() && this.hoverTime() >= this.getTooltipDelay();
    }

    public void tick(double mouseX, double mouseY) {
        this.hoverTime = this.isMouseOver() ? ++this.hoverTime : 0;
        for (GuiElement<?> childElement : this.childElements) {
            childElement.tick(mouseX, mouseY);
        }
    }

    public boolean updateMouseOver(double mouseX, double mouseY, boolean consumed) {
        for (GuiElement child : Lists.reverse(this.getChildren())) {
            if (!child.isEnabled()) continue;
            consumed |= child.updateMouseOver(mouseX, mouseY, consumed);
        }
        this.isMouseOver = !consumed && GuiRender.isInRect(this.xMin(), this.yMin(), this.xSize(), this.ySize(), mouseX, mouseY) && !this.blockMouseOver(this, mouseX, mouseY);
        return consumed || this.isMouseOver && this.isOpaque();
    }

    @Override
    public Supplier<List<Component>> getTooltip() {
        return this.toolTip;
    }

    @Override
    public T setTooltipDelay(int tooltipDelay) {
        this.hoverTextDelay = tooltipDelay;
        return (T)((GuiElement)SneakyUtils.unsafeCast(this));
    }

    @Override
    public int getTooltipDelay() {
        return this.hoverTextDelay;
    }

    @Override
    public T setTooltip(@Nullable Supplier<List<Component>> tooltip) {
        this.toolTip = tooltip;
        return (T)((GuiElement)SneakyUtils.unsafeCast(this));
    }

    public T jeiExclude() {
        this.isJeiExcluded = true;
        return (T)((GuiElement)SneakyUtils.unsafeCast(this));
    }

    public T setJeiExcluded(boolean jeiExcluded) {
        this.isJeiExcluded = jeiExcluded;
        return (T)((GuiElement)SneakyUtils.unsafeCast(this));
    }

    public boolean isJeiExcluded() {
        return this.isJeiExcluded;
    }

    public T setJeiDropTarget(Consumer<ItemStack> onDrop, boolean installStandardHighlight) {
        this.jeiDropConsumer = onDrop;
        if (installStandardHighlight) {
            GuiRectangle highlight = ((GuiRectangle)new GuiRectangle(this).setEnabled(() -> this.getModularGui().getJeiHighlightTime() > 0)).fill(() -> ColourARGB.packARGB(0, 255, 0, Math.min(this.getModularGui().getJeiHighlightTime() * 2, 80)));
            Constraints.bind(highlight, this);
        }
        return (T)((GuiElement)SneakyUtils.unsafeCast(this));
    }

    public Consumer<ItemStack> getJeiDropConsumer() {
        return this.jeiDropConsumer;
    }

    public boolean isJeiDropTarget() {
        return this.jeiDropConsumer != null;
    }

    public List<GuiElement<?>> addJeiExclusions(List<GuiElement<?>> list) {
        if (this.isJeiExcluded()) {
            list.add(this);
        }
        for (GuiElement<?> child : this.childElements) {
            if (!child.isEnabled()) continue;
            child.addJeiExclusions(list);
        }
        return list;
    }

    public List<GuiElement<?>> addJeiDropTargets(List<GuiElement<?>> list) {
        if (this.isJeiDropTarget()) {
            list.add(this);
        }
        for (GuiElement<?> child : this.childElements) {
            if (!child.isEnabled()) continue;
            child.addJeiDropTargets(list);
        }
        return list;
    }
}

