/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.gui.modular.elements;

import codechicken.lib.gui.modular.ModularGui;
import codechicken.lib.gui.modular.elements.GuiButton;
import codechicken.lib.gui.modular.elements.GuiElement;
import codechicken.lib.gui.modular.elements.GuiRectangle;
import codechicken.lib.gui.modular.elements.GuiText;
import codechicken.lib.gui.modular.lib.Constraints;
import codechicken.lib.gui.modular.lib.geometry.ConstrainedGeometry;
import codechicken.lib.gui.modular.lib.geometry.Constraint;
import codechicken.lib.gui.modular.lib.geometry.ConstraintImpl;
import codechicken.lib.gui.modular.lib.geometry.GeoParam;
import codechicken.lib.gui.modular.lib.geometry.GuiParent;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.covers1624.quack.collection.FastStream;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuiDialog
extends GuiElement<GuiDialog> {
    private boolean blockKeyInput = true;
    private boolean blockMouseInput = true;

    protected GuiDialog(@NotNull GuiParent<?> parent) {
        super(parent);
    }

    public static GuiDialog optionsDialog(@NotNull GuiParent<?> parent, @Nullable Component title, Component dialogText, int width, Option ... options) {
        return GuiDialog.optionsDialog(parent, title, dialogText, GuiRectangle::toolTipBackground, GuiDialog::defaultButton, width, options);
    }

    public static GuiDialog optionsDialog(@NotNull GuiParent<?> parent, Component dialogText, int width, Option ... options) {
        return GuiDialog.optionsDialog(parent, null, dialogText, width, options);
    }

    public static GuiDialog infoDialog(@NotNull GuiParent<?> parent, @Nullable Component title, Component dialogText, int width, @Nullable Runnable okAction) {
        return GuiDialog.optionsDialog(parent, title, dialogText, width, GuiDialog.neutral((Component)Component.translatable((String)"gui.ok"), okAction));
    }

    public static GuiDialog infoDialog(@NotNull GuiParent<?> parent, @Nullable Component title, Component dialogText, int width) {
        return GuiDialog.infoDialog(parent, title, dialogText, width, null);
    }

    public static GuiDialog infoDialog(@NotNull GuiParent<?> parent, Component dialogText, int width) {
        return GuiDialog.infoDialog(parent, null, dialogText, width);
    }

    public static Option primary(Component text, @Nullable Runnable action) {
        return new Option(text, action, hovered -> hovered != false ? -12277180 : -15628271);
    }

    public static Option neutral(Component text, @Nullable Runnable action) {
        return new Option(text, action, hovered -> hovered != false ? -7303024 : -11513776);
    }

    public static Option caution(Component text, @Nullable Runnable action) {
        return new Option(text, action, hovered -> hovered != false ? -5618620 : -7859951);
    }

    public GuiDialog setBlockKeyInput(boolean blockKeyInput) {
        this.blockKeyInput = blockKeyInput;
        return this;
    }

    public GuiDialog setBlockMouseInput(boolean blockMouseInput) {
        this.blockMouseInput = blockMouseInput;
        return this;
    }

    public void close() {
        this.getParent().removeChild(this);
    }

    @Override
    public boolean keyPressed(int key, int scancode, int modifiers) {
        return this.blockKeyInput;
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        return this.blockMouseInput;
    }

    public static GuiDialog optionsDialog(@NotNull GuiParent<?> parent, @Nullable Component title, Component dialogText, Function<GuiDialog, GuiElement<?>> backgroundBuilder, BiFunction<GuiDialog, Option, GuiButton> buttonBuilder, int width, Option ... options) {
        if (options.length == 0) {
            throw new IllegalStateException("Can not create gui dialog with no options!");
        }
        ModularGui gui = parent.getModularGui();
        GuiDialog dialog = (GuiDialog)((GuiDialog)new GuiDialog(gui.getRoot()).constrain(GeoParam.WIDTH, Constraint.literal(width))).setOpaque(true);
        Constraints.bind((ConstrainedGeometry)backgroundBuilder.apply(dialog), dialog);
        ConstraintImpl.Relative left = Constraint.relative(dialog.get(GeoParam.LEFT), 5.0);
        ConstraintImpl.Relative right = Constraint.relative(dialog.get(GeoParam.RIGHT), -5.0);
        if (title != null) {
            GuiText titleText = ((GuiText)((GuiText)((GuiText)new GuiText(dialog, title).setWrap(true).constrain(GeoParam.TOP, Constraint.relative(dialog.get(GeoParam.TOP), 5.0))).constrain(GeoParam.LEFT, left)).constrain(GeoParam.RIGHT, right)).autoHeight();
            GuiText bodyText = ((GuiText)((GuiText)((GuiText)new GuiText(dialog, dialogText).setWrap(true).constrain(GeoParam.TOP, Constraint.relative(titleText.get(GeoParam.BOTTOM), 5.0))).constrain(GeoParam.LEFT, left)).constrain(GeoParam.RIGHT, right)).autoHeight();
            dialog.constrain(GeoParam.HEIGHT, Constraint.dynamic(() -> 5.0 + titleText.ySize() + 5.0 + bodyText.ySize() + 5.0 + 14.0 + 5.0));
        } else {
            GuiText bodyText = ((GuiText)((GuiText)((GuiText)new GuiText(dialog, dialogText).setWrap(true).constrain(GeoParam.TOP, Constraint.relative(dialog.get(GeoParam.TOP), 5.0))).constrain(GeoParam.LEFT, left)).constrain(GeoParam.RIGHT, right)).autoHeight();
            dialog.constrain(GeoParam.HEIGHT, Constraint.dynamic(() -> 5.0 + bodyText.ySize() + 5.0 + 14.0 + 5.0));
        }
        double totalWidth = FastStream.of(options).doubleSum(e -> dialog.font().width((FormattedText)e.text));
        double pos = 5.0;
        int spacing = 2;
        for (Option option : options) {
            double fraction = (double)dialog.font().width((FormattedText)option.text) / totalWidth;
            double opWidth = (dialog.xSize() - 10.0 - (double)((options.length - 1) * spacing)) * fraction;
            ((GuiButton)((GuiButton)((GuiButton)buttonBuilder.apply(dialog, option).constrain(GeoParam.BOTTOM, Constraint.relative(dialog.get(GeoParam.BOTTOM), -5.0))).constrain(GeoParam.HEIGHT, Constraint.literal(14.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.relative(dialog.get(GeoParam.LEFT), pos).precise())).constrain(GeoParam.WIDTH, (Constraint)Constraint.literal(opWidth).precise());
            pos += opWidth + (double)spacing;
        }
        dialog.constrain(GeoParam.TOP, Constraint.midPoint(gui.get(GeoParam.TOP), gui.get(GeoParam.BOTTOM), () -> -(dialog.ySize() / 2.0)));
        dialog.constrain(GeoParam.LEFT, Constraint.midPoint(gui.get(GeoParam.LEFT), gui.get(GeoParam.RIGHT), -((double)width / 2.0)));
        return dialog;
    }

    private static GuiButton defaultButton(GuiDialog dialog, Option option) {
        GuiButton button = new GuiButton(dialog);
        GuiRectangle background = new GuiRectangle(button).fill(() -> option.colour.apply(button.isMouseOver()));
        Constraints.bind(background, button);
        GuiText text = new GuiText(button, option.text());
        button.setLabel(text);
        Constraints.bind(text, button, 0.0, 2.0, 0.0, 2.0);
        button.onPress(() -> {
            if (option.action != null) {
                option.action.run();
            }
            dialog.close();
        });
        return button;
    }

    public record Option(Component text, @Nullable Runnable action, Function<Boolean, Integer> colour) {
    }
}

