/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.chunky.iterator;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import org.popcraft.chunky.Chunky;
import org.popcraft.chunky.Selection;
import org.popcraft.chunky.iterator.ChunkIterator;
import org.popcraft.chunky.nbt.StringTag;
import org.popcraft.chunky.nbt.util.ChunkFilter;
import org.popcraft.chunky.nbt.util.RegionFile;
import org.popcraft.chunky.util.ChunkCoordinate;
import org.popcraft.chunky.util.Hilbert;
import org.popcraft.chunky.util.Parameter;

public class WorldChunkIterator
implements ChunkIterator {
    private final Chunky chunky;
    private final int minRegionX;
    private final int minRegionZ;
    private final int maxRegionX;
    private final int maxRegionZ;
    private final int minChunkX;
    private final int minChunkZ;
    private final int maxChunkX;
    private final int maxChunkZ;
    private final String worldName;
    private final Queue<ChunkCoordinate> chunks;
    private final AtomicLong total = new AtomicLong();
    private final Path savePath;
    private final Path regionPath;
    private final String name;

    public WorldChunkIterator(Selection selection) {
        this.chunky = selection.chunky();
        int centerRegionX = selection.centerRegionX();
        int centerRegionZ = selection.centerRegionZ();
        int radiusRegionsX = selection.radiusRegionsX();
        int radiusRegionsZ = selection.radiusRegionsZ();
        this.minRegionX = centerRegionX - radiusRegionsX;
        this.minRegionZ = centerRegionZ - radiusRegionsZ;
        this.maxRegionX = centerRegionX + radiusRegionsX;
        this.maxRegionZ = centerRegionZ + radiusRegionsZ;
        int centerChunkX = selection.centerChunkX();
        int centerChunkZ = selection.centerChunkZ();
        int radiusChunksX = selection.radiusChunksX();
        int radiusChunksZ = selection.radiusChunksZ();
        this.minChunkX = centerChunkX - radiusChunksX;
        this.minChunkZ = centerChunkZ - radiusChunksZ;
        this.maxChunkX = centerChunkX + radiusChunksX;
        this.maxChunkZ = centerChunkZ + radiusChunksZ;
        this.chunks = new LinkedList<ChunkCoordinate>();
        this.worldName = selection.world().getName();
        String saveFile = this.worldName.substring(this.worldName.indexOf(58) + 1);
        this.savePath = selection.chunky().getConfig().getDirectory().resolve(String.format("%s.csv", saveFile));
        this.regionPath = selection.world().getRegionDirectory().orElse(null);
        this.name = Parameter.of("csv", saveFile).toString();
    }

    @Override
    public boolean hasNext() {
        return !this.chunks.isEmpty();
    }

    @Override
    public ChunkCoordinate next() {
        if (this.chunks.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.chunks.poll();
    }

    @Override
    public long total() {
        return this.total.get();
    }

    @Override
    public String name() {
        return this.name;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean process() {
        if (this.regionPath == null) {
            return false;
        }
        long startTime = System.currentTimeMillis();
        AtomicLong updateTime = new AtomicLong(startTime);
        StringBuilder saveData = new StringBuilder();
        try (Stream<Path> files = Files.list(this.regionPath);){
            List<Path> regions = files.filter(file -> {
                ChunkCoordinate regionCoordinate = ChunkCoordinate.fromRegionFile(file.getFileName().toString()).orElse(null);
                return regionCoordinate != null && regionCoordinate.x() >= this.minRegionX && regionCoordinate.x() <= this.maxRegionX && regionCoordinate.z() >= this.minRegionZ && regionCoordinate.z() <= this.maxRegionZ;
            }).toList();
            long totalRegions = regions.size();
            AtomicLong finishedRegions = new AtomicLong();
            for (Path region : regions) {
                ChunkCoordinate regionCoordinate = ChunkCoordinate.fromRegionFile(region.getFileName().toString()).orElseThrow(IllegalStateException::new);
                int regionX = regionCoordinate.x();
                int regionZ = regionCoordinate.z();
                RegionFile regionFile = new RegionFile(region.toFile(), ChunkFilter.of((byte)8, "Status"));
                for (ChunkCoordinate offset : Hilbert.chunkCoordinateOffsets()) {
                    ChunkCoordinate chunkCoordinate = new ChunkCoordinate((regionX << 5) + offset.x(), (regionZ << 5) + offset.z());
                    if (chunkCoordinate.x() < this.minChunkX || chunkCoordinate.x() > this.maxChunkX || chunkCoordinate.z() < this.minChunkZ || chunkCoordinate.z() > this.maxChunkZ) continue;
                    regionFile.getChunk(chunkCoordinate.x(), chunkCoordinate.z()).ifPresent(chunk -> {
                        boolean generated = Optional.ofNullable(chunk.getData()).filter(StringTag.class::isInstance).map(StringTag.class::cast).map(StringTag::value).map(status -> "minecraft:full".equals(status) || "full".equals(status)).orElse(false);
                        if (generated) {
                            this.chunks.add(chunkCoordinate);
                            saveData.append(chunkCoordinate.x()).append(',').append(chunkCoordinate.z()).append('\n');
                            this.total.incrementAndGet();
                        }
                    });
                }
                finishedRegions.getAndIncrement();
                if (!this.chunky.getConfig().isSilent()) {
                    boolean updateIntervalElapsed;
                    long currentTime = System.currentTimeMillis();
                    boolean bl = updateIntervalElapsed = (double)(currentTime - updateTime.get()) / 1000.0 > (double)this.chunky.getConfig().getUpdateInterval();
                    if (updateIntervalElapsed || finishedRegions.get() == totalRegions) {
                        this.chunky.getServer().getConsole().sendMessagePrefixed("task_trim_update", this.worldName, finishedRegions.get(), String.format("%.2f", Float.valueOf(100.0f * (float)finishedRegions.get() / (float)totalRegions)));
                        updateTime.set(currentTime);
                    }
                }
                if (!Thread.interrupted()) continue;
                Thread.currentThread().interrupt();
                boolean bl = false;
                return bl;
            }
            Files.writeString(this.savePath, (CharSequence)saveData, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }
}

