/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.utils.misc;

import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import pregenerator.base.api.TextUtil;
import pregenerator.common.deleter.tasks.DeletionCircle;
import pregenerator.common.deleter.tasks.DeletionCircleArea;
import pregenerator.common.deleter.tasks.DeletionCircleExpansion;
import pregenerator.common.deleter.tasks.DeletionSquare;
import pregenerator.common.deleter.tasks.DeletionSquareArea;
import pregenerator.common.deleter.tasks.DeletionSquareExpansion;
import pregenerator.common.deleter.tasks.IDeletionTask;
import pregenerator.common.generator.GenerationType;
import pregenerator.common.generator.tasks.CircleAreaTask;
import pregenerator.common.generator.tasks.CircleExpansionTask;
import pregenerator.common.generator.tasks.CircleTask;
import pregenerator.common.generator.tasks.ITask;
import pregenerator.common.generator.tasks.SquareAreaTask;
import pregenerator.common.generator.tasks.SquareExpansionTask;
import pregenerator.common.generator.tasks.SquareTask;

public enum GenShape {
    SQUARE{

        @Override
        public long calculateRadius(long radius) {
            return radius * radius * 4L;
        }

        @Override
        public long calculateRadius(long minRadius, long maxRadius) {
            return maxRadius * maxRadius * 4L - minRadius * minRadius * 4L;
        }

        @Override
        public long calculateRadius(ChunkPos from, ChunkPos to) {
            return (long)((to.x - to.x) * (to.z - to.z)) * 4L;
        }

        @Override
        public boolean isInsideArea(int radius, int x, int z) {
            return x >= -radius || x < radius || z >= -radius || z < radius;
        }

        @Override
        public Component getName() {
            return TextUtil.translate("task.chunk_pregen.shape_type.square");
        }

        @Override
        public ITask createRadiusGenTask(String name, int x, int z, int radius, GenerationType type, ResourceKey<Level> dim) {
            return new SquareTask(name, dim, type.getIndex(), new ChunkPos(x, z), radius);
        }

        @Override
        public ITask createExpansionGenTask(String name, int x, int z, int minRadius, int maxRadius, GenerationType type, ResourceKey<Level> dim) {
            return new SquareExpansionTask(name, dim, type.getIndex(), new ChunkPos(x, z), minRadius, maxRadius);
        }

        @Override
        public ITask createAreaGenTask(String name, ChunkPos min, ChunkPos max, GenerationType type, ResourceKey<Level> dim) {
            return new SquareAreaTask(name, dim, type.getIndex(), min, max);
        }

        @Override
        public IDeletionTask createRadiusDeleteTask(String name, int x, int z, int radius, ResourceKey<Level> dim) {
            return new DeletionSquare(name, dim, new ChunkPos(x, z), radius);
        }

        @Override
        public IDeletionTask createExpansionDeleteTask(String name, int x, int z, int minRadius, int maxRadius, ResourceKey<Level> dim) {
            return new DeletionSquareExpansion(name, dim, new ChunkPos(x, z), minRadius, maxRadius);
        }

        @Override
        public IDeletionTask createAreaDeleteTask(String name, ChunkPos min, ChunkPos max, ResourceKey<Level> dim) {
            return new DeletionSquareArea(name, dim, min, max);
        }
    }
    ,
    CIRCLE{

        @Override
        public long calculateRadius(long radius) {
            return (long)((double)(radius * radius) * Math.PI);
        }

        @Override
        public long calculateRadius(long minRadius, long maxRadius) {
            return (long)((double)(maxRadius * maxRadius) * Math.PI - (double)(minRadius * minRadius) * Math.PI);
        }

        @Override
        public long calculateRadius(ChunkPos from, ChunkPos to) {
            return (long)((double)((to.x - to.x) * (to.z - to.z)) * Math.PI * 0.25);
        }

        @Override
        public boolean isInsideArea(int radius, int x, int z) {
            return x * x + z * z < radius * radius;
        }

        @Override
        public Component getName() {
            return TextUtil.translate("task.chunk_pregen.shape_type.circle");
        }

        @Override
        public ITask createRadiusGenTask(String name, int x, int z, int radius, GenerationType type, ResourceKey<Level> dim) {
            return new CircleTask(name, dim, type.getIndex(), new ChunkPos(x, z), radius);
        }

        @Override
        public ITask createExpansionGenTask(String name, int x, int z, int minRadius, int maxRadius, GenerationType type, ResourceKey<Level> dim) {
            return new CircleExpansionTask(name, dim, type.getIndex(), new ChunkPos(x, z), minRadius, maxRadius);
        }

        @Override
        public ITask createAreaGenTask(String name, ChunkPos min, ChunkPos max, GenerationType type, ResourceKey<Level> dim) {
            return new CircleAreaTask(name, dim, type.getIndex(), min, max);
        }

        @Override
        public IDeletionTask createRadiusDeleteTask(String name, int x, int z, int radius, ResourceKey<Level> dim) {
            return new DeletionCircle(name, dim, new ChunkPos(x, z), radius);
        }

        @Override
        public IDeletionTask createExpansionDeleteTask(String name, int x, int z, int minRadius, int maxRadius, ResourceKey<Level> dim) {
            return new DeletionCircleExpansion(name, dim, new ChunkPos(x, z), minRadius, maxRadius);
        }

        @Override
        public IDeletionTask createAreaDeleteTask(String name, ChunkPos min, ChunkPos max, ResourceKey<Level> dim) {
            return new DeletionCircleArea(name, dim, min, max);
        }
    };


    public long calculateRadius(long radius) {
        throw new UnsupportedOperationException();
    }

    public long calculateRadius(long minRadius, long maxRadius) {
        throw new UnsupportedOperationException();
    }

    public long calculateRadius(ChunkPos from, ChunkPos to) {
        throw new UnsupportedOperationException();
    }

    public boolean isInsideArea(int radius, int x, int z) {
        throw new UnsupportedOperationException();
    }

    public Component getName() {
        throw new UnsupportedOperationException();
    }

    public ITask createRadiusGenTask(String name, int x, int z, int radius, GenerationType type, ResourceKey<Level> dim) {
        throw new UnsupportedOperationException();
    }

    public ITask createExpansionGenTask(String name, int x, int z, int minRadius, int maxRadius, GenerationType type, ResourceKey<Level> dim) {
        throw new UnsupportedOperationException();
    }

    public ITask createAreaGenTask(String name, ChunkPos min, ChunkPos max, GenerationType type, ResourceKey<Level> dim) {
        throw new UnsupportedOperationException();
    }

    public IDeletionTask createRadiusDeleteTask(String name, int x, int z, int radius, ResourceKey<Level> dim) {
        throw new UnsupportedOperationException();
    }

    public IDeletionTask createExpansionDeleteTask(String name, int x, int z, int minRadius, int maxRadius, ResourceKey<Level> dim) {
        throw new UnsupportedOperationException();
    }

    public IDeletionTask createAreaDeleteTask(String name, ChunkPos min, ChunkPos max, ResourceKey<Level> dim) {
        throw new UnsupportedOperationException();
    }
}

