/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.utils.config.internal;

import carbonconfiglib.api.IConfigSerializer;
import carbonconfiglib.api.ISuggestionProvider;
import carbonconfiglib.api.buffer.IReadBuffer;
import carbonconfiglib.api.buffer.IWriteBuffer;
import carbonconfiglib.utils.ParseResult;
import carbonconfiglib.utils.ParsedCollections;
import carbonconfiglib.utils.structure.IStructuredData;
import carbonconfiglib.utils.structure.StructureCompound;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.authlib.GameProfile;
import com.mojang.util.UndashedUuid;
import java.io.Reader;
import java.nio.file.Files;
import java.util.EnumSet;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import pregenerator.common.utils.misc.PregenAction;

public class PermissionRule {
    UUID player;
    EnumSet<PregenAction> actions;

    public PermissionRule() {
        this(UUID.fromString("84d6171c-8546-4309-bf3e-fc0956f32ea0"), EnumSet.of(PregenAction.ALL_DELETION, PregenAction.COMMANDS, PregenAction.ALL_SCANNING));
    }

    public PermissionRule(UUID player, EnumSet<PregenAction> actions) {
        this.player = player;
        this.actions = actions;
    }

    public UUID getPlayer() {
        return this.player;
    }

    public EnumSet<PregenAction> getActions() {
        return this.actions;
    }

    public boolean hasAction(PregenAction action) {
        return this.actions.contains((Object)action);
    }

    public static ParseResult<PermissionRule> parse(ParsedCollections.ParsedMap map) {
        ParseResult playerId = map.getOrError("PlayerId", String.class);
        if (playerId.hasError()) {
            return playerId.onlyError();
        }
        UUID id = (UUID)playerId.map(PermissionRule::parseUUID);
        if (id == null) {
            return ParseResult.error((String)((String)playerId.getValue()), (String)("Id [" + (String)playerId.getValue() + "] isn't a valid UUID"));
        }
        EnumSet<PregenAction> set = EnumSet.noneOf(PregenAction.class);
        for (PregenAction action : PregenAction.values()) {
            ParseResult result = map.getOrError(action.getName(), Boolean.class);
            if (result.hasError()) {
                return result.onlyError();
            }
            if (!((Boolean)result.getValue()).booleanValue()) continue;
            set.add(action);
        }
        return ParseResult.success((Object)new PermissionRule(id, set));
    }

    public ParsedCollections.ParsedMap serialize() {
        ParsedCollections.ParsedMap map = new ParsedCollections.ParsedMap();
        map.put("PlayerId", (Object)this.player.toString());
        for (PregenAction action : PregenAction.values()) {
            map.put(action.getName(), (Object)this.actions.contains((Object)action));
        }
        return map;
    }

    public static PermissionRule read(IReadBuffer buffer) {
        UUID id = buffer.readUUID();
        EnumSet<PregenAction> set = EnumSet.noneOf(PregenAction.class);
        for (PregenAction action : PregenAction.values()) {
            if (!buffer.readBoolean()) continue;
            set.add(action);
        }
        return new PermissionRule(id, set);
    }

    public static void write(IWriteBuffer buffer, PermissionRule rules) {
        buffer.writeUUID(rules.player);
        for (PregenAction action : PregenAction.values()) {
            buffer.writeBoolean(rules.actions.contains((Object)action));
        }
    }

    public static UUID parseUUID(String arg) {
        try {
            return UndashedUuid.fromStringLenient((String)arg);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static IConfigSerializer<PermissionRule> createPermissions() {
        StructureCompound.CompoundBuilder builder = new StructureCompound.CompoundBuilder();
        builder.simple("PlayerId", IStructuredData.EntryDataType.STRING).addSuggestions(new ISuggestionProvider[]{new PlayerSuggestions()}).finish();
        for (PregenAction action : PregenAction.values()) {
            builder.simple(action.getName(), IStructuredData.EntryDataType.BOOLEAN).finish();
        }
        return IConfigSerializer.withSync((StructureCompound.CompoundData)builder.build(), (Object)new PermissionRule(), PermissionRule::parse, PermissionRule::serialize, PermissionRule::read, PermissionRule::write);
    }

    public static class PlayerSuggestions
    implements ISuggestionProvider {
        public void provideSuggestions(Consumer<ISuggestionProvider.Suggestion> output, Predicate<ISuggestionProvider.Suggestion> filter) {
            this.collectProfiles(T -> {
                ISuggestionProvider.Suggestion suggestion = ISuggestionProvider.Suggestion.namedValue((String)T.getName(), (String)T.getId().toString());
                if (filter.test(suggestion)) {
                    output.accept(suggestion);
                }
            });
        }

        @OnlyIn(value=Dist.CLIENT)
        private void collectProfiles(Consumer<GameProfile> profile) {
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            if (server != null) {
                for (ServerPlayer player : server.getPlayerList().getPlayers()) {
                    profile.accept(player.getGameProfile());
                }
            }
            try {
                JsonArray array = JsonParser.parseReader((Reader)Files.newBufferedReader(FMLPaths.GAMEDIR.get().resolve("usercache.json"))).getAsJsonArray();
                int m = array.size();
                for (int i = 0; i < m; ++i) {
                    JsonObject obj = array.get(i).getAsJsonObject();
                    String name = obj.get("name").getAsString();
                    UUID id = PermissionRule.parseUUID(obj.get("uuid").getAsString());
                    if (id == null || name == null) continue;
                    profile.accept(new GameProfile(id, name));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

