/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.tracker.types;

import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import pregenerator.base.mixins.common.chunk.ChunkHolderMixin;
import pregenerator.base.mixins.common.storage.ChunkManagerMixin;
import pregenerator.common.tracker.WorldTracker;
import pregenerator.common.tracker.types.BaseWorldEntry;
import pregenerator.common.tracker.types.IWorldEntry;

public class TileEntry
extends BaseWorldEntry {
    int blockId;
    boolean isTicking;

    public TileEntry(BlockEntityType<?> type, int count, Block block, boolean isTicking) {
        this(BuiltInRegistries.BLOCK_ENTITY_TYPE.getId(type), count, BuiltInRegistries.BLOCK.getId((Object)block), isTicking);
    }

    public TileEntry(int id, int count, int blockId, boolean isTicking) {
        super(id, count);
        this.blockId = blockId;
        this.isTicking = isTicking;
    }

    public TileEntry(FriendlyByteBuf buffer) {
        super(buffer);
        this.blockId = buffer.readVarInt();
        this.isTicking = buffer.readBoolean();
    }

    public boolean isTicking() {
        return this.isTicking;
    }

    public Block getType() {
        return (Block)BuiltInRegistries.BLOCK.byId(this.blockId);
    }

    @Override
    protected ResourceLocation getKey(int id, RegistryAccess registry) {
        return BuiltInRegistries.BLOCK_ENTITY_TYPE.getKey((Object)((BlockEntityType)BuiltInRegistries.BLOCK_ENTITY_TYPE.byId(id)));
    }

    @Override
    public Component getName(RegistryAccess registry) {
        return this.getType().getName();
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        super.write(buffer);
        buffer.writeVarInt(this.blockId);
        buffer.writeBoolean(this.isTicking);
    }

    @Override
    public boolean canDelete(boolean chunk) {
        return true;
    }

    @Override
    public int deleteWorld(WorldTracker tracker, Player player) {
        BlockEntityType type = (BlockEntityType)BuiltInRegistries.BLOCK_ENTITY_TYPE.byId(this.id);
        if (type == null) {
            return 0;
        }
        ObjectArrayList entities = new ObjectArrayList(this.count);
        TileEntry.getBlockEntities(tracker.getWorld(), arg_0 -> TileEntry.lambda$deleteWorld$0(type, (List)entities, arg_0));
        entities.forEach(T -> tracker.getWorld().removeBlock(T.getBlockPos(), false));
        return entities.size();
    }

    @Override
    public int deleteChunk(WorldTracker tracker, long position) {
        LevelChunk chunk = tracker.getChunk(position);
        if (chunk == null) {
            return 0;
        }
        BlockEntityType type = (BlockEntityType)BuiltInRegistries.BLOCK_ENTITY_TYPE.byId(this.id);
        if (type == null) {
            return 0;
        }
        ObjectArrayList entities = new ObjectArrayList(chunk.getBlockEntities().values());
        entities.removeIf(T -> T.getType() != type);
        entities.forEach(T -> tracker.getWorld().removeBlock(T.getBlockPos(), false));
        return entities.size();
    }

    public static List<IWorldEntry> getLevel(ServerLevel level) {
        Object2ObjectLinkedOpenHashMap typeMap = new Object2ObjectLinkedOpenHashMap();
        ObjectOpenHashSet ticking = new ObjectOpenHashSet();
        BaseWorldEntry.Counter<BlockEntityType> counter = new BaseWorldEntry.Counter<BlockEntityType>();
        TileEntry.getBlockEntities(level, arg_0 -> TileEntry.lambda$getLevel$4((Map)typeMap, counter, level, (Set)ticking, arg_0));
        return counter.map((arg_0, arg_1) -> TileEntry.lambda$getLevel$5((Map)typeMap, (Set)ticking, arg_0, arg_1));
    }

    public static List<IWorldEntry> getChunk(LevelChunk chunk) {
        Object2ObjectLinkedOpenHashMap typeMap = new Object2ObjectLinkedOpenHashMap();
        ObjectOpenHashSet ticking = new ObjectOpenHashSet();
        BaseWorldEntry.Counter<BlockEntityType> counter = new BaseWorldEntry.Counter<BlockEntityType>();
        for (BlockEntity entity : chunk.getBlockEntities().values()) {
            typeMap.putIfAbsent(entity.getType(), entity.getBlockState().getBlock());
            counter.add(entity.getType());
            if (entity.getBlockState().getTicker(chunk.getLevel(), entity.getType()) == null) continue;
            ticking.add(entity.getType());
        }
        return counter.map((arg_0, arg_1) -> TileEntry.lambda$getChunk$6((Map)typeMap, (Set)ticking, arg_0, arg_1));
    }

    public static void getBlockEntities(ServerLevel level, Consumer<BlockEntity> result) {
        for (ChunkHolder holder : ((ChunkManagerMixin)level.getChunkSource().chunkMap).getLoadedChunks()) {
            ChunkHolderMixin mixin = (ChunkHolderMixin)holder;
            LevelChunk chunk = mixin.getLoadingChunk();
            if (chunk == null) {
                ChunkAccess testChunk = holder.getChunkIfPresent(ChunkStatus.FULL);
                if (!(testChunk instanceof LevelChunk)) continue;
                chunk = (LevelChunk)testChunk;
            }
            chunk.getBlockEntities().values().forEach(result);
        }
    }

    private static /* synthetic */ IWorldEntry lambda$getChunk$6(Map typeMap, Set ticking, BlockEntityType T, int C) {
        return new TileEntry(T, C, (Block)typeMap.get(T), ticking.contains(T));
    }

    private static /* synthetic */ IWorldEntry lambda$getLevel$5(Map typeMap, Set ticking, BlockEntityType T, int C) {
        return new TileEntry(T, C, (Block)typeMap.get(T), ticking.contains(T));
    }

    private static /* synthetic */ void lambda$getLevel$4(Map typeMap, BaseWorldEntry.Counter counter, ServerLevel level, Set ticking, BlockEntity T) {
        typeMap.putIfAbsent(T.getType(), T.getBlockState().getBlock());
        counter.add(T.getType());
        if (T.getBlockState().getTicker((Level)level, T.getType()) != null) {
            ticking.add(T.getType());
        }
    }

    private static /* synthetic */ void lambda$deleteWorld$0(BlockEntityType type, List entities, BlockEntity T) {
        if (T.getType() != type) {
            return;
        }
        entities.add(T);
    }
}

