/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.tracker.types;

import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import pregenerator.base.api.TextUtil;
import pregenerator.common.tracker.types.IWorldEntry;

public abstract class BaseWorldEntry
implements IWorldEntry {
    int id;
    int count;

    public BaseWorldEntry(int id, int count) {
        this.id = id;
        this.count = count;
    }

    public BaseWorldEntry(FriendlyByteBuf buf) {
        this.id = buf.readVarInt();
        this.count = buf.readVarInt();
    }

    @Override
    public ResourceLocation getKey(RegistryAccess registry) {
        return this.getKey(this.id, registry);
    }

    protected abstract ResourceLocation getKey(int var1, RegistryAccess var2);

    @Override
    public Component getName(RegistryAccess registry) {
        return TextUtil.literalPascal(this.getKey(this.id, registry).getPath());
    }

    @Override
    public int getCount() {
        return this.count;
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.writeVarInt(this.id);
        buffer.writeVarInt(this.count);
    }

    public static class Counter<T> {
        Object2IntLinkedOpenHashMap<T> counter = new Object2IntLinkedOpenHashMap();

        public void add(T key, int amount) {
            this.counter.addTo(key, amount);
        }

        public void add(T key) {
            this.counter.addTo(key, 1);
        }

        public void remove(Predicate<T> remove) {
            this.counter.keySet().removeIf(remove);
        }

        public <E> List<E> map(Mapper<T, E> function) {
            ObjectArrayList result = new ObjectArrayList();
            for (Object2IntMap.Entry entry : this.counter.object2IntEntrySet()) {
                result.add(function.map(entry.getKey(), entry.getIntValue()));
            }
            return result;
        }

        public void merge(Counter<T> other) {
            for (Object2IntMap.Entry entry : other.counter.object2IntEntrySet()) {
                this.counter.addTo(entry.getKey(), entry.getIntValue());
            }
        }

        public static interface Mapper<T, E> {
            public E map(T var1, int var2);
        }
    }
}

