/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.tracker;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.Int2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import pregenerator.base.mixins.common.chunk.ChunkSectionMixin;
import pregenerator.common.tracker.types.IWorldEntry;
import pregenerator.common.tracker.types.TileEntry;

public class ChunkEntry {
    long pos;
    Int2ObjectMap<List<IWorldEntry>> data;
    int randomTicking;

    public ChunkEntry(long pos, Int2ObjectMap<List<IWorldEntry>> data, int randomTicking) {
        this.pos = pos;
        this.data = data;
        this.randomTicking = randomTicking;
    }

    public int getDistance(BlockPos position) {
        int x = position.getX() - ((ChunkPos.getX((long)this.pos) << 4) + 8);
        int z = position.getZ() - ((ChunkPos.getZ((long)this.pos) << 4) + 8);
        return (int)Math.sqrt(x * x + z * z);
    }

    public int getX() {
        return ChunkPos.getX((long)this.pos);
    }

    public int getZ() {
        return ChunkPos.getZ((long)this.pos);
    }

    public long getPos() {
        return this.pos;
    }

    public <T extends IWorldEntry> List<T> get(int type, Class<T> clz) {
        return Lists.transform((List)((List)this.data.get(type)), clz::cast);
    }

    public int getTypes(int type) {
        return ((List)this.data.get(type)).size();
    }

    public int getTiles() {
        return IWorldEntry.count((List)this.data.get(0));
    }

    public int getTickingTiles() {
        int total = 0;
        for (TileEntry entry : Lists.transform((List)((List)this.data.get(0)), TileEntry.class::cast)) {
            if (!entry.isTicking()) continue;
            total += entry.getCount();
        }
        return total;
    }

    public int getEntities() {
        return IWorldEntry.count((List)this.data.get(1));
    }

    public int getBlocks() {
        return IWorldEntry.count((List)this.data.get(3));
    }

    public int getTickingBlocks() {
        return this.randomTicking;
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeLong(this.pos);
        for (int i = 0; i < 4; ++i) {
            List entries = (List)this.data.get(i);
            buffer.writeVarInt(entries.size());
            entries.forEach(T -> T.write(buffer));
        }
        buffer.writeVarInt(this.randomTicking);
    }

    public static ChunkEntry fromNetwork(RegistryFriendlyByteBuf buffer) {
        Int2ObjectLinkedOpenHashMap data = new Int2ObjectLinkedOpenHashMap();
        long pos = buffer.readLong();
        for (int i = 0; i < 4; ++i) {
            ObjectArrayList list = new ObjectArrayList();
            Function<RegistryFriendlyByteBuf, IWorldEntry> creator = IWorldEntry.byId(i);
            int size = buffer.readVarInt();
            for (int j = 0; j < size; ++j) {
                list.add(creator.apply(buffer));
            }
            data.put(i, (Object)list);
        }
        return new ChunkEntry(pos, (Int2ObjectMap<List<IWorldEntry>>)data, buffer.readVarInt());
    }

    public static ChunkEntry fromChunk(LevelChunk chunk) {
        Int2ObjectLinkedOpenHashMap data = new Int2ObjectLinkedOpenHashMap();
        int randomCount = 0;
        for (int i = 0; i < 4; ++i) {
            data.put(i, IWorldEntry.byChunk(i, chunk));
        }
        for (LevelChunkSection section : chunk.getSections()) {
            if (section.hasOnlyAir() || !section.isRandomlyTickingBlocks()) continue;
            randomCount += ((ChunkSectionMixin)section).getTickingBlocksCount();
        }
        return new ChunkEntry(chunk.getPos().toLong(), (Int2ObjectMap<List<IWorldEntry>>)data, randomCount);
    }
}

