/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.structures;

import com.google.common.base.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import pregenerator.base.api.TextUtil;

public class StructureRef {
    ResourceLocation id;
    long pos;
    int components;
    int size;
    int[] bounds;

    public StructureRef(ResourceLocation id, StructureStart start) {
        this.id = id;
        this.pos = start.getChunkPos().toLong();
        this.components = start.getPieces().size();
        BoundingBox box = start.getBoundingBox();
        this.bounds = new int[]{box.minX(), box.minY(), box.minZ(), box.maxX(), box.maxY(), box.maxZ()};
        this.size = this.calculateChunkSize();
    }

    public StructureRef(ResourceLocation name, int[] data) {
        this.id = name;
        this.pos = ChunkPos.asLong((int)data[0], (int)data[1]);
        this.components = data[2];
        this.size = data[3];
        this.bounds = new int[6];
        for (int i = 0; i < 6; ++i) {
            this.bounds[i] = data[4 + i];
        }
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.pos});
    }

    public boolean equals(Object obj) {
        if (obj instanceof StructureRef) {
            return ((StructureRef)obj).pos == this.pos;
        }
        return false;
    }

    public int[] write() {
        int[] index = new int[10];
        index[0] = ChunkPos.getX((long)this.pos);
        index[1] = ChunkPos.getZ((long)this.pos);
        index[2] = this.components;
        index[3] = this.size;
        for (int i = 0; i < 6; ++i) {
            index[4 + i] = this.bounds[i];
        }
        return index;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public Component getDisplayName() {
        MutableComponent mod = TextUtil.translate("gui.chunk_pregen.biome_preview.tooltip.structure_mod", TextUtil.getModName(this.id.getNamespace())).withStyle(ChatFormatting.GOLD);
        return TextUtil.translate("gui.chunk_pregen.biome_preview.tooltip.structure_name", TextUtil.literalPascal(this.id.getPath()), mod).withStyle(ChatFormatting.BLUE);
    }

    public int[] getBounds() {
        return this.bounds;
    }

    public int getSize() {
        return this.size;
    }

    private int calculateChunkSize() {
        int width = this.bounds[3] - this.bounds[0];
        int depth = this.bounds[5] - this.bounds[2];
        return (int)Math.sqrt(width * width + depth * depth);
    }
}

