/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.networking.packets;

import it.unimi.dsi.fastutil.objects.Object2BooleanLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2FloatLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import pregenerator.ChunkPregenerator;
import pregenerator.base.api.TextUtil;
import pregenerator.client.gui.commands.TaskScreen;
import pregenerator.common.deleter.tasks.IDeletionTask;
import pregenerator.common.generator.tasks.ITask;
import pregenerator.common.manager.ServerManager;
import pregenerator.common.networking.IPregenPacket;
import pregenerator.common.networking.NetworkManager;
import pregenerator.common.utils.misc.PregenAction;

public class TaskPacket {
    public static final StreamCodec<RegistryFriendlyByteBuf, RequestTasks> REQUEST_TASKS_CODEC = CustomPacketPayload.codec(IPregenPacket.IRequestPacket::write, IPregenPacket.readPacket(RequestTasks::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, RequestSpeeds> REQUEST_SPEEDS_CODEC = CustomPacketPayload.codec(IPregenPacket.IRequestPacket::write, IPregenPacket.readPacket(RequestSpeeds::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, AnswerTasks> ANSWER_TASKS_CODEC = CustomPacketPayload.codec(AnswerTasks::write, IPregenPacket.readPacket(AnswerTasks::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, AnswerSpeeds> ANSWER_SPEEDS_CODEC = CustomPacketPayload.codec(AnswerSpeeds::write, IPregenPacket.readPacket(AnswerSpeeds::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, Action> ACTIONS_CODEC = CustomPacketPayload.codec(Action::write, IPregenPacket.readPacket(Action::new));
    public static final CustomPacketPayload.Type<RequestTasks> REQUEST_TASKS = IPregenPacket.createType("chunkpregen:task_request_tasks");
    public static final CustomPacketPayload.Type<RequestSpeeds> REQUEST_SPEEDS = IPregenPacket.createType("chunkpregen:task_request_speeds");
    public static final CustomPacketPayload.Type<AnswerTasks> ANSWER_TASKS = IPregenPacket.createType("chunkpregen:task_answer_tasks");
    public static final CustomPacketPayload.Type<AnswerSpeeds> ANSWER_SPEEDS = IPregenPacket.createType("chunkpregen:task_answer_speeds");
    public static final CustomPacketPayload.Type<Action> ACTIONS = IPregenPacket.createType("chunkpregen:task_actions");

    public static interface ISpeedReceiver {
        public void acceptSpeedData(Object2FloatMap<ResourceKey<Level>> var1);
    }

    public static interface TaskFunction<T> {
        public T apply(List<ITask> var1, List<IDeletionTask> var2, Object2BooleanMap<UUID> var3);
    }

    public static class AnswerSpeeds
    implements IPregenPacket {
        Object2FloatMap<ResourceKey<Level>> speeds = new Object2FloatLinkedOpenHashMap();

        public AnswerSpeeds(Object2FloatMap<ResourceKey<Level>> speeds) {
            this.speeds = speeds;
        }

        public AnswerSpeeds(RegistryFriendlyByteBuf buffer) {
            IPregenPacket.readMap(buffer, this.speeds, T -> ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)T.readResourceLocation()), FriendlyByteBuf::readFloat);
        }

        public void write(RegistryFriendlyByteBuf buffer) {
            IPregenPacket.writeMap(buffer, this.speeds, (K, V) -> K.writeResourceLocation(V.location()), FriendlyByteBuf::writeFloat);
        }

        @Override
        public void process(Player player) {
            this.processClient();
        }

        @OnlyIn(value=Dist.CLIENT)
        public void processClient() {
            Screen screen = Minecraft.getInstance().screen;
            if (screen instanceof ISpeedReceiver) {
                ((ISpeedReceiver)screen).acceptSpeedData(this.speeds);
            }
        }

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return ANSWER_SPEEDS;
        }
    }

    public static class RequestSpeeds
    implements IPregenPacket.IRequestPacket {
        public RequestSpeeds() {
        }

        public RequestSpeeds(RegistryFriendlyByteBuf buf) {
        }

        @Override
        public void process(Player player) {
            if (!ChunkPregenerator.canDoAction(player, PregenAction.COMMANDS)) {
                player.displayClientMessage((Component)TextUtil.translate("network.chunk_pregen.failures.no_permissions"), false);
                return;
            }
            Object2FloatLinkedOpenHashMap speeds = new Object2FloatLinkedOpenHashMap();
            for (ResourceKey dim : ServerLifecycleHooks.getCurrentServer().levelKeys()) {
                speeds.put((Object)dim, ServerManager.INSTANCE.getChunksPerTick((ResourceKey<Level>)dim));
            }
            NetworkManager.INSTANCE.sendToPlayer(new AnswerSpeeds((Object2FloatMap<ResourceKey<Level>>)speeds), player);
        }

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return REQUEST_SPEEDS;
        }
    }

    public static class AnswerTasks
    implements IPregenPacket {
        List<ITask> tasks = new ObjectArrayList();
        List<IDeletionTask> deletions = new ObjectArrayList();
        Object2BooleanMap<UUID> activeTasks = new Object2BooleanLinkedOpenHashMap();

        public AnswerTasks(List<ITask> tasks, List<IDeletionTask> deletions, Object2BooleanMap<UUID> activeTasks) {
            this.tasks = tasks;
            this.deletions = deletions;
            this.activeTasks = activeTasks;
        }

        public AnswerTasks(RegistryFriendlyByteBuf buffer) {
            IPregenPacket.readCollection(buffer, this.tasks, T -> ITask.loadTask(T.readNbt()));
            IPregenPacket.readCollection(buffer, this.deletions, T -> IDeletionTask.loadTask(T.readNbt()));
            IPregenPacket.readMap(buffer, this.activeTasks, T -> T.readUUID(), FriendlyByteBuf::readBoolean);
        }

        public void write(RegistryFriendlyByteBuf buffer) {
            IPregenPacket.writeCollection(buffer, this.tasks, (T, B) -> B.writeNbt((Tag)ITask.saveTask(T)));
            IPregenPacket.writeCollection(buffer, this.deletions, (T, B) -> B.writeNbt((Tag)IDeletionTask.saveTask(T)));
            IPregenPacket.writeMap(buffer, this.activeTasks, (T, B) -> T.writeUUID(B), FriendlyByteBuf::writeBoolean);
        }

        @Override
        public void process(Player player) {
            this.processClient();
        }

        @OnlyIn(value=Dist.CLIENT)
        public void processClient() {
            Screen screen = Minecraft.getInstance().screen;
            if (screen instanceof TaskScreen) {
                ((TaskScreen)screen).acceptTasks(this.tasks, this.deletions, this.activeTasks);
            }
        }

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return ANSWER_TASKS;
        }
    }

    public static class Action
    implements IPregenPacket {
        int action;
        String taskName;

        public Action(int action, String taskName) {
            this.action = action;
            this.taskName = taskName;
        }

        public Action(RegistryFriendlyByteBuf buffer) {
            this.action = buffer.readVarInt();
            this.taskName = buffer.readUtf();
        }

        public void write(RegistryFriendlyByteBuf buffer) {
            buffer.writeVarInt(this.action);
            buffer.writeUtf(this.taskName);
        }

        @Override
        public void process(Player player) {
            if (!ChunkPregenerator.canDoAction(player, PregenAction.COMMANDS)) {
                player.displayClientMessage((Component)TextUtil.translate("network.chunk_pregen.failures.no_permissions"), false);
                return;
            }
            switch (this.action) {
                case 0: {
                    ServerManager.INSTANCE.pauseTask(this.taskName, arg_0 -> ((Player)player).sendSystemMessage(arg_0));
                    break;
                }
                case 1: {
                    ServerManager.INSTANCE.resumeTask(this.taskName, arg_0 -> ((Player)player).sendSystemMessage(arg_0));
                    break;
                }
                case 2: {
                    ServerManager.INSTANCE.stopTask(this.taskName, arg_0 -> ((Player)player).sendSystemMessage(arg_0), false);
                    break;
                }
                case 3: {
                    ServerManager.INSTANCE.continueTask(this.taskName, player.getUUID(), arg_0 -> ((Player)player).sendSystemMessage(arg_0));
                    break;
                }
                case 4: {
                    ServerManager.INSTANCE.removeTask(this.taskName, arg_0 -> ((Player)player).sendSystemMessage(arg_0));
                }
            }
            NetworkManager.INSTANCE.sendToPlayer(ServerManager.INSTANCE.getTasks(AnswerTasks::new), player);
        }

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return ACTIONS;
        }
    }

    public static class RequestTasks
    implements IPregenPacket.IRequestPacket {
        public RequestTasks() {
        }

        public RequestTasks(RegistryFriendlyByteBuf buf) {
        }

        @Override
        public void process(Player player) {
            if (!ChunkPregenerator.canDoAction(player, PregenAction.COMMANDS)) {
                player.displayClientMessage((Component)TextUtil.translate("network.chunk_pregen.failures.no_permissions"), false);
                return;
            }
            NetworkManager.INSTANCE.sendToPlayer(ServerManager.INSTANCE.getTasks(AnswerTasks::new), player);
        }

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return REQUEST_TASKS;
        }
    }
}

