/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.networking.packets;

import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import pregenerator.client.ClientHandler;
import pregenerator.common.manager.ServerManager;
import pregenerator.common.networking.IPregenPacket;
import pregenerator.common.networking.NetworkManager;

public class OverlayPacket {
    public static final StreamCodec<RegistryFriendlyByteBuf, Request> REQUEST_CODEC = CustomPacketPayload.codec(IPregenPacket.IRequestPacket::write, IPregenPacket.readPacket(Request::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, Answer> ANSWER_CODEC = CustomPacketPayload.codec(Answer::write, IPregenPacket.readPacket(Answer::new));
    public static final CustomPacketPayload.Type<Request> REQUEST = IPregenPacket.createType("chunkpregen:overlay_request");
    public static final CustomPacketPayload.Type<Answer> ANSWER = IPregenPacket.createType("chunkpregen:overlay_answer");

    public static class Answer
    implements IPregenPacket {
        byte[] data;

        public Answer(byte[] data) {
            this.data = data;
        }

        public Answer(RegistryFriendlyByteBuf buffer) {
            this.data = buffer.readByteArray();
        }

        public void write(RegistryFriendlyByteBuf buffer) {
            buffer.writeByteArray(this.data);
        }

        @Override
        public void process(Player player) {
            ClientHandler.INSTANCE.onInfoPacketReceived(this.data);
        }

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return ANSWER;
        }
    }

    public static class Request
    implements IPregenPacket.IRequestPacket {
        public Request() {
        }

        public Request(RegistryFriendlyByteBuf buf) {
        }

        @Override
        public void process(Player player) {
            NetworkManager.INSTANCE.sendToPlayer(new Answer(ServerManager.INSTANCE.sendData()), player);
        }

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return REQUEST;
        }
    }
}

