/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.networking;

import java.text.DecimalFormat;
import java.util.Collection;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamDecoder;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import pregenerator.base.api.TextUtil;

public interface IPregenPacket
extends CustomPacketPayload {
    public static final DecimalFormat NUMBERS = TextUtil.NUMBERS;
    public static final DecimalFormat FLOATING_NUMBERS = TextUtil.FLOATING_NUMBERS;

    public void process(Player var1);

    public static <T extends CustomPacketPayload> CustomPacketPayload.Type<T> createType(String p_319908_) {
        return new CustomPacketPayload.Type(ResourceLocation.parse((String)p_319908_));
    }

    public static <T extends IPregenPacket> StreamDecoder<RegistryFriendlyByteBuf, T> readPacket(Function<RegistryFriendlyByteBuf, T> provider) {
        return B -> {
            try {
                return (IPregenPacket)provider.apply((RegistryFriendlyByteBuf)B);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        };
    }

    public static <K, V> void writeMap(RegistryFriendlyByteBuf buffer, Map<K, V> elements, BiConsumer<RegistryFriendlyByteBuf, K> keyWriter, BiConsumer<RegistryFriendlyByteBuf, V> valueWriter) {
        buffer.writeVarInt(elements.size());
        for (Map.Entry<K, V> entry : elements.entrySet()) {
            keyWriter.accept(buffer, entry.getKey());
            valueWriter.accept(buffer, entry.getValue());
        }
    }

    public static <K, V> void readMap(RegistryFriendlyByteBuf buffer, Map<K, V> output, Function<RegistryFriendlyByteBuf, K> keyReader, Function<RegistryFriendlyByteBuf, V> valueReader) {
        int size = buffer.readVarInt();
        for (int i = 0; i < size; ++i) {
            K key = keyReader.apply(buffer);
            V value = valueReader.apply(buffer);
            if (key == null || value == null) continue;
            output.put(key, value);
        }
    }

    public static <T> void writeCollection(RegistryFriendlyByteBuf buffer, Collection<T> elements, BiConsumer<T, RegistryFriendlyByteBuf> action) {
        buffer.writeVarInt(elements.size());
        for (T entry : elements) {
            action.accept(entry, buffer);
        }
    }

    public static <T> void writeCollectionReverse(RegistryFriendlyByteBuf buffer, Collection<T> elements, BiConsumer<RegistryFriendlyByteBuf, T> action) {
        buffer.writeVarInt(elements.size());
        for (T entry : elements) {
            action.accept(buffer, (RegistryFriendlyByteBuf)entry);
        }
    }

    public static <T> void readCollection(RegistryFriendlyByteBuf buffer, Collection<T> output, Function<RegistryFriendlyByteBuf, T> parser) {
        int size = buffer.readVarInt();
        for (int i = 0; i < size; ++i) {
            T result = parser.apply(buffer);
            if (result == null) continue;
            output.add(result);
        }
    }

    public static interface IRequestPacket
    extends IPregenPacket {
        default public void write(RegistryFriendlyByteBuf buffer) {
        }
    }
}

