/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.manager;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectIterators;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.progress.ChunkProgressListener;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.border.BorderChangeListener;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.WorldOptions;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DerivedLevelData;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.ServerLevelData;
import net.minecraft.world.level.storage.WorldData;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import pregenerator.base.api.TextUtil;
import pregenerator.base.mixins.common.server.MinecraftServerMixin;
import pregenerator.base.mixins.common.storage.ChunkManagerMixin;

public class DimensionManager {
    public static final DimensionManager INSTANCE = new DimensionManager();

    public void disableDimension(ResourceKey<Level> dimension, Consumer<Component> listener) {
        if (this.canUnloadDimension(ServerLifecycleHooks.getCurrentServer(), dimension, listener)) {
            MutableComponent dim = TextUtil.dimension(dimension);
            if (!DimensionRegistry.getRegistry().addDimension(dimension.location())) {
                listener.accept((Component)TextUtil.translate("command.chunk_pregen.dimension.already_unloaded", dim).withStyle(ChatFormatting.RED));
                return;
            }
            listener.accept((Component)TextUtil.translate("command.chunk_pregen.dimension.unloading", dim));
            this.unloadDimension(ServerLifecycleHooks.getCurrentServer(), dimension);
            listener.accept((Component)TextUtil.translate("command.chunk_pregen.dimension.unloaded", dim));
        }
    }

    public void enableDimension(ResourceKey<Level> dimension, Consumer<Component> listener) {
        if (DimensionRegistry.getRegistry().removeDimension(dimension.location())) {
            MutableComponent dim = TextUtil.dimension(dimension);
            listener.accept((Component)TextUtil.translate("command.chunk_pregen.dimension.loading", dim));
            this.loadDimension(ServerLifecycleHooks.getCurrentServer(), dimension);
            listener.accept((Component)TextUtil.translate("command.chunk_pregen.dimension.loaded", dim));
            return;
        }
        listener.accept((Component)TextUtil.translate("command.chunk_pregen.dimension.already_loaded", TextUtil.dimension(dimension)).withStyle(ChatFormatting.RED));
    }

    public void onServerStarting(ServerStartingEvent event) {
        MinecraftServer server = event.getServer();
        for (ResourceLocation dim : DimensionRegistry.getDims()) {
            this.syncTime(server);
            this.unloadDimension(server, (ResourceKey<Level>)ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)dim));
        }
    }

    private boolean canUnloadDimension(MinecraftServer server, ResourceKey<Level> world, Consumer<Component> listener) {
        if (Level.OVERWORLD.location().equals((Object)world.location())) {
            listener.accept((Component)TextUtil.translate("command.chunk_pregen.dimension.error.overworld"));
            return false;
        }
        ServerLevel serverWorld = server.getLevel(world);
        if (serverWorld == null) {
            listener.accept((Component)TextUtil.translate("command.chunk_pregen.dimension.error.not_exist", TextUtil.dimension(world)).withStyle(ChatFormatting.RED));
            return false;
        }
        if (serverWorld.players().size() > 0) {
            listener.accept((Component)TextUtil.translate("command.chunk_pregen.dimension.error.players"));
            return false;
        }
        return true;
    }

    private void loadDimension(MinecraftServer server, ResourceKey<Level> world) {
        WorldData config = server.getWorldData();
        WorldOptions settings = config.worldGenOptions();
        LevelStem dim = (LevelStem)server.registryAccess().registryOrThrow(Registries.LEVEL_STEM).get(ResourceKey.create((ResourceKey)Registries.LEVEL_STEM, (ResourceLocation)world.location()));
        ServerLevel serverWorld = new ServerLevel(server, (Executor)Util.backgroundExecutor(), this.getLevelSave(server), (ServerLevelData)new DerivedLevelData(config, config.overworldData()), world, dim, this.getStatusListener(server), config.isDebugWorld(), BiomeManager.obfuscateSeed((long)settings.seed()), (List)ImmutableList.of(), true, server.overworld().getRandomSequences());
        server.getLevel(Level.OVERWORLD).getWorldBorder().addListener((BorderChangeListener)new BorderChangeListener.DelegateBorderChangeListener(serverWorld.getWorldBorder()));
        server.forgeGetWorldMap().put(world, serverWorld);
        server.markWorldsDirty();
    }

    private void unloadDimension(MinecraftServer server, ResourceKey<Level> key) {
        ServerLevel world = server.getLevel(key);
        if (world == null) {
            return;
        }
        world.save(null, true, false);
        NeoForge.EVENT_BUS.post((Event)new LevelEvent.Unload((LevelAccessor)world));
        try {
            world.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        server.forgeGetWorldMap().remove(key);
        server.markWorldsDirty();
    }

    private LevelStorageSource.LevelStorageAccess getLevelSave(MinecraftServer server) {
        return ((MinecraftServerMixin)server).getCurrentSave();
    }

    private ChunkProgressListener getStatusListener(MinecraftServer server) {
        return ((ChunkManagerMixin)server.getLevel((ResourceKey)Level.OVERWORLD).getChunkSource().chunkMap).getStatusListener();
    }

    public void syncTime(MinecraftServer server) {
        ((MinecraftServerMixin)server).setServerTime(Util.getNanos() + 100000000L);
    }

    public static class DimensionRegistry
    extends SavedData {
        private static final SavedData.Factory<DimensionRegistry> FACTORY = new SavedData.Factory(DimensionRegistry::new, DimensionRegistry::loadData, DataFixTypes.SAVED_DATA_COMMAND_STORAGE);
        ObjectSet<ResourceLocation> locations = new ObjectLinkedOpenHashSet();

        public static DimensionRegistry getRegistry() {
            return (DimensionRegistry)ServerLifecycleHooks.getCurrentServer().getLevel(Level.OVERWORLD).getDataStorage().computeIfAbsent(FACTORY, "pregen_dimensions");
        }

        public static DimensionRegistry loadData(CompoundTag data, HolderLookup.Provider prov) {
            DimensionRegistry registry = new DimensionRegistry();
            registry.load(data, prov);
            return registry;
        }

        public void load(CompoundTag nbt, HolderLookup.Provider prov) {
            this.locations.clear();
            ListTag list = nbt.getList("dimensions", 8);
            int i = 0;
            while (i < list.size()) {
                this.locations.add((Object)ResourceLocation.parse((String)list.getString(i++)));
            }
        }

        public CompoundTag save(CompoundTag compound, HolderLookup.Provider prov) {
            ListTag list = new ListTag();
            for (ResourceLocation location : this.locations) {
                list.add((Object)StringTag.valueOf((String)location.toString()));
            }
            compound.put("dimensions", (Tag)list);
            return compound;
        }

        public boolean addDimension(ResourceLocation location) {
            if (!Level.OVERWORLD.location().equals((Object)location) && this.locations.add((Object)location)) {
                this.setDirty();
                return true;
            }
            return false;
        }

        public boolean removeDimension(ResourceLocation location) {
            if (this.locations.remove((Object)location)) {
                this.setDirty();
                return true;
            }
            return false;
        }

        public static Iterable<ResourceLocation> getDims() {
            return () -> ObjectIterators.unmodifiable((ObjectIterator)DimensionRegistry.getRegistry().locations.iterator());
        }
    }
}

