/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.generator.tasks;

import java.time.Duration;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import pregenerator.base.api.TextUtil;
import pregenerator.common.generator.ChunkProcess;
import pregenerator.common.generator.GenerationType;
import pregenerator.common.generator.tasks.ITask;
import pregenerator.common.manager.IProcess;
import pregenerator.common.utils.misc.Area;

public abstract class BaseTask
implements ITask {
    String name;
    ResourceKey<Level> type;
    int genType;
    UUID task = UUID.randomUUID();
    UUID owner;
    boolean throwEvents = true;
    long activeTime = 0L;

    public BaseTask(CompoundTag nbt) {
        this(nbt.getString("name"), (ResourceKey<Level>)ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)nbt.getString("dim"))), nbt.getInt("genType"));
        this.throwEvents = nbt.getBoolean("events");
        this.activeTime = nbt.getLong("active_time");
        if (nbt.hasUUID("taskId")) {
            this.task = nbt.getUUID("taskId");
        }
        if (nbt.hasUUID("owner")) {
            this.owner = nbt.getUUID("owner");
        }
    }

    public BaseTask(String name, ResourceKey<Level> type, int genType) {
        this.name = name;
        this.type = type;
        this.genType = genType;
    }

    @Override
    public void setOwner(UUID id) {
        this.owner = id;
    }

    public BaseTask setThrowEvents() {
        this.throwEvents = true;
        return this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ResourceKey<Level> getDimension() {
        return this.type;
    }

    @Override
    public int getGenType() {
        return this.genType;
    }

    @Override
    public UUID getTaskId() {
        return this.task;
    }

    @Override
    public UUID getOwner() {
        return this.owner;
    }

    @Override
    public Area getArea() {
        return new Area(this.getCenter(), this.getMaxRadius());
    }

    @Override
    public void addActiveTime(long amount) {
        this.activeTime += amount;
    }

    @Override
    public long getActiveTime() {
        return this.activeTime;
    }

    @Override
    public MutableComponent getTaskDescription() {
        MutableComponent text = TextUtil.literal(this.name);
        ITask.insert("task.chunk_pregen.name", this.getName(), text, ChatFormatting.AQUA);
        ITask.insert("task.chunk_pregen.dimension", TextUtil.dimension(this.getDimension()), text, ChatFormatting.GREEN);
        ITask.insert("task.chunk_pregen.genType", GenerationType.values()[this.genType].createText(), text, ChatFormatting.AQUA);
        this.append(text);
        ITask.removeLast(text.getSiblings());
        return TextUtil.translate("task.chunk_pregen.wrap", text);
    }

    public abstract void append(MutableComponent var1);

    @Override
    public boolean isValid() {
        return this.type != null;
    }

    @Override
    public CompoundTag write() {
        CompoundTag nbt = new CompoundTag();
        nbt.putString("name", this.name);
        nbt.putString("dim", this.type.location().toString());
        nbt.putByte("genType", (byte)this.genType);
        nbt.putUUID("taskId", this.task);
        nbt.putLong("active_time", this.activeTime);
        if (this.throwEvents) {
            nbt.putBoolean("events", this.throwEvents);
        }
        if (this.owner != null) {
            nbt.putUUID("owner", this.owner);
        }
        return nbt;
    }

    @Override
    public void onCompletion(Duration terrainTime, Duration lightTime, long totalChunks) {
    }

    @Override
    public CompletableFuture<ChunkProcess> createTask(ServerLevel world, Executor exe, IProcess.PrepareProgress progress) {
        return CompletableFuture.supplyAsync(() -> this.createTask(world, progress), exe);
    }

    public abstract ChunkProcess createTask(ServerLevel var1, IProcess.PrepareProgress var2);
}

