/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.deleter.tasks;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.ChunkPos;
import pregenerator.common.base.IBaseTask;
import pregenerator.common.deleter.ChunkDeleter;
import pregenerator.common.deleter.tasks.DeletionCircle;
import pregenerator.common.deleter.tasks.DeletionCircleArea;
import pregenerator.common.deleter.tasks.DeletionCircleExpansion;
import pregenerator.common.deleter.tasks.DeletionExcess;
import pregenerator.common.deleter.tasks.DeletionSpecific;
import pregenerator.common.deleter.tasks.DeletionSquare;
import pregenerator.common.deleter.tasks.DeletionSquareArea;
import pregenerator.common.deleter.tasks.DeletionSquareExpansion;
import pregenerator.common.deleter.tasks.DeletionTimeOut;

public interface IDeletionTask
extends IBaseTask<ChunkDeleter> {
    public static final Int2ObjectMap<Function<CompoundTag, IDeletionTask>> TASK_REGISTRY = new Int2ObjectOpenHashMap();

    public static void init() {
        TASK_REGISTRY.put(1, DeletionSquare::new);
        TASK_REGISTRY.put(2, DeletionCircle::new);
        TASK_REGISTRY.put(3, DeletionSquareExpansion::new);
        TASK_REGISTRY.put(4, DeletionCircleExpansion::new);
        TASK_REGISTRY.put(5, DeletionExcess::new);
        TASK_REGISTRY.put(6, DeletionTimeOut::new);
        TASK_REGISTRY.put(7, DeletionSquareArea::new);
        TASK_REGISTRY.put(8, DeletionCircleArea::new);
        TASK_REGISTRY.put(9, DeletionSpecific::new);
    }

    public static IDeletionTask loadTask(CompoundTag nbt) {
        Function creator = (Function)TASK_REGISTRY.get(nbt.getInt("id"));
        if (creator == null) {
            return null;
        }
        IDeletionTask task = (IDeletionTask)creator.apply(nbt);
        return task == null || !task.isValid() ? null : task;
    }

    public static CompoundTag saveTask(IDeletionTask task) {
        if (task == null) {
            return null;
        }
        CompoundTag nbt = task.write();
        nbt.putByte("id", task.getId());
        return nbt;
    }

    public ChunkPos getCenter();

    public int getMaxRadius();
}

