/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.deleter.tasks;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.nio.file.Path;
import java.util.BitSet;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.storage.RegionFile;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import pregenerator.base.api.TextUtil;
import pregenerator.common.deleter.ChunkDeleter;
import pregenerator.common.deleter.tasks.BaseDeletionTask;
import pregenerator.common.generator.tasks.ITask;
import pregenerator.common.manager.IProcess;

public class DeletionExcess
extends BaseDeletionTask {
    ChunkPos center;
    int radius;
    long cachedSize = -1L;

    public DeletionExcess(CompoundTag nbt) {
        super(nbt);
        this.center = new ChunkPos(nbt.getLong("center"));
        this.radius = nbt.getInt("radius");
        this.cachedSize = nbt.contains("cache") ? nbt.getLong("cache") : -1L;
    }

    public DeletionExcess(String name, ResourceKey<Level> type, ChunkPos center, int radius) {
        super(name, type);
        this.center = center;
        this.radius = radius;
    }

    @Override
    public CompoundTag write() {
        CompoundTag nbt = super.write();
        nbt.putInt("radius", this.radius);
        nbt.putLong("center", this.center.toLong());
        if (this.cachedSize != -1L) {
            nbt.putLong("cache", this.cachedSize);
        }
        return nbt;
    }

    @Override
    public byte getId() {
        return 5;
    }

    @Override
    public Component getShapeName() {
        return TextUtil.translate("task.chunk_pregen.shape_type.excess");
    }

    @Override
    public int getMaxRadius() {
        return this.radius;
    }

    @Override
    public ChunkPos getCenter() {
        return this.center;
    }

    @Override
    public long getTaskSize() {
        return this.cachedSize == -1L ? (this.cachedSize = this.calculateCacheSize()) : this.cachedSize;
    }

    @Override
    public void append(MutableComponent builder) {
        ITask.insert("task.chunk_pregen.task_type", TextUtil.translate("task.chunk_pregen.shape_type.excess"), builder, ChatFormatting.DARK_PURPLE);
        ITask.insert("task.chunk_pregen.x_coord", this.center.x, builder, ChatFormatting.YELLOW);
        ITask.insert("task.chunk_pregen.z_coord", this.center.z, builder, ChatFormatting.YELLOW);
        ITask.insert("task.chunk_pregen.min_radius", this.radius, builder, ChatFormatting.BLUE);
    }

    @Override
    public ChunkDeleter createTask(ServerLevel world, IProcess.PrepareProgress progress) {
        Long2ObjectOpenHashMap toDelete = new Long2ObjectOpenHashMap();
        long total = 0L;
        RegionStorageInfo info = new RegionStorageInfo(this.getAccess().getLevelId(), this.getDimension(), "chunk");
        progress.setMax((long)this.getRegionFiles().size() * 1024L);
        for (Path subFile : this.getRegionFiles()) {
            if (!progress.isAlive()) break;
            String[] name = subFile.getFileName().toString().split("\\.");
            int minX = (Integer.parseInt(name[1]) << 5) - this.center.x;
            int minZ = (Integer.parseInt(name[2]) << 5) - this.center.z;
            if (minX < -this.radius || minX + 32 > this.radius || minZ < -this.radius || minZ + 32 > this.radius) {
                try (RegionFile file = new RegionFile(info, subFile, subFile.getParent(), false);){
                    BitSet set = new BitSet(1024);
                    for (int i = 0; i < 1024; ++i) {
                        int x = i % 32 + minX;
                        int z = i / 32 + minZ;
                        if (x <= this.radius && x >= -this.radius && z <= this.radius && z >= -this.radius || !file.hasChunk(new ChunkPos(i % 32, i / 32))) continue;
                        set.set(i);
                        ++total;
                    }
                    if (!set.isEmpty()) {
                        toDelete.put(ChunkPos.asLong((int)(minX >> 5), (int)(minZ >> 5)), (Object)set);
                    }
                    progress.growValue(1024);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            progress.growValue(1024);
        }
        this.cachedSize = total;
        return new ChunkDeleter((ResourceKey<Level>)this.type, this.getSaveFile(), world).init((Long2ObjectMap<BitSet>)toDelete, this.center, progress);
    }

    private long calculateCacheSize() {
        long total = 0L;
        RegionStorageInfo info = new RegionStorageInfo(this.getAccess().getLevelId(), this.getDimension(), "chunk");
        for (Path subFile : this.getRegionFiles()) {
            String[] name = subFile.getFileName().toString().split("\\.");
            int minX = (Integer.parseInt(name[1]) << 5) - this.center.x;
            int minZ = (Integer.parseInt(name[2]) << 5) - this.center.z;
            if (minX >= -this.radius && minX + 32 <= this.radius && minZ >= -this.radius && minZ + 32 <= this.radius) continue;
            try (RegionFile file = new RegionFile(info, subFile, subFile.getParent(), false);){
                for (int i = 0; i < 1024; ++i) {
                    int x = i % 32 + minX;
                    int z = i / 32 + minZ;
                    if (x <= this.radius && x >= -this.radius && z <= this.radius && z >= -this.radius || !file.hasChunk(new ChunkPos(i % 32, i / 32))) continue;
                    ++total;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return total;
    }
}

