/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.deleter.tasks;

import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import pregenerator.base.api.TextUtil;
import pregenerator.common.deleter.ChunkDeleter;
import pregenerator.common.deleter.tasks.BaseDeletionTask;
import pregenerator.common.generator.ChunkShapeBuilder;
import pregenerator.common.generator.tasks.ITask;
import pregenerator.common.manager.IProcess;
import pregenerator.common.utils.misc.Area;

public class DeletionCircleArea
extends BaseDeletionTask {
    long min;
    long max;
    long center;

    public DeletionCircleArea(String name, ResourceKey<Level> type, ChunkPos min, ChunkPos max) {
        super(name, type);
        this.min = min.toLong();
        this.max = max.toLong();
        this.center = ChunkPos.asLong((int)(min.x + (max.x - min.x) / 2), (int)(min.z + (max.z - min.z) / 2));
    }

    public DeletionCircleArea(CompoundTag nbt) {
        super(nbt);
        this.min = nbt.getLong("min");
        this.max = nbt.getLong("max");
        this.center = nbt.getLong("center");
    }

    @Override
    public CompoundTag write() {
        CompoundTag tag = super.write();
        tag.putLong("min", this.min);
        tag.putLong("max", this.max);
        tag.putLong("center", this.center);
        return tag;
    }

    @Override
    public byte getId() {
        return 8;
    }

    @Override
    public Component getShapeName() {
        return TextUtil.translate("task.chunk_pregen.shape_type.circle_area");
    }

    @Override
    public ChunkPos getCenter() {
        return new ChunkPos(this.center);
    }

    @Override
    public int getMaxRadius() {
        return Math.max((ChunkPos.getX((long)this.max) - ChunkPos.getX((long)this.min)) / 2, (ChunkPos.getZ((long)this.max) - ChunkPos.getZ((long)this.min)) / 2);
    }

    @Override
    public Area getArea() {
        return new Area(new ChunkPos(this.min), new ChunkPos(this.max));
    }

    @Override
    public long getTaskSize() {
        long x = ChunkPos.getX((long)this.max) - ChunkPos.getX((long)this.min);
        long z = ChunkPos.getZ((long)this.max) - ChunkPos.getZ((long)this.min);
        return (long)((double)(x * z) * Math.PI);
    }

    @Override
    public void append(MutableComponent builder) {
        ChunkPos min = new ChunkPos(this.min);
        ChunkPos max = new ChunkPos(this.max);
        ITask.insert("task.chunk_pregen.task_type", TextUtil.translate("task.chunk_pregen.shape_type.circle_area"), builder, ChatFormatting.DARK_PURPLE);
        ITask.insert("task.chunk_pregen.from", new Object[]{min.x, min.z}, builder, ChatFormatting.YELLOW);
        ITask.insert("task.chunk_pregen.to", new Object[]{max.x, max.z}, builder, ChatFormatting.YELLOW);
    }

    @Override
    public ChunkDeleter createTask(ServerLevel world, IProcess.PrepareProgress progress) {
        progress.setMax(this.getTaskSize());
        ChunkDeleter deleter = new ChunkDeleter((ResourceKey<Level>)this.type, this.getSaveFile(), world);
        ChunkPos min = new ChunkPos(this.min);
        ChunkPos max = new ChunkPos(this.max);
        return deleter.init(ChunkShapeBuilder.genCircleArea(min.x, min.z, max.x, max.z, progress), new ChunkPos(this.center), progress);
    }
}

