/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.commands;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import net.neoforged.neoforge.server.command.EnumArgument;
import pregenerator.base.api.TextUtil;
import pregenerator.common.generator.tasks.BenchmarkTask;
import pregenerator.common.manager.BenchmarkManager;
import pregenerator.common.manager.ServerManager;
import pregenerator.common.utils.misc.CommandBuilder;
import pregenerator.common.utils.misc.CommandWrapper;

public class BenchmarkCommand {
    public static CommandBuilder createBenchmark(boolean advArgs) {
        CommandBuilder builder = new CommandBuilder("benchmark");
        builder.literal("info", BenchmarkCommand::info).pop();
        builder.literal("start", BenchmarkCommand::runBenchmark);
        BenchmarkCommand.appendSize(builder, BenchmarkCommand::runBenchmark, advArgs);
        builder.popTop().literal("start_single").arg("dim", (ArgumentType<?>)DimensionArgument.dimension(), BenchmarkCommand::runSingleBenchmark);
        BenchmarkCommand.appendSize(builder, BenchmarkCommand::runSingleBenchmark, advArgs);
        return builder;
    }

    private static void appendSize(CommandBuilder builder, Consumer<CommandWrapper> task, boolean advArgs) {
        if (advArgs) {
            builder.arg("Task-Size", (ArgumentType<?>)EnumArgument.enumArgument(BenchmarkManager.BenchmarkSize.class), (SuggestionProvider<CommandSourceStack>)((SuggestionProvider)BenchmarkCommand::listSuggestions), task);
        } else {
            builder.arg("Small Task", (ArgumentType<?>)BoolArgumentType.bool(), task);
        }
    }

    private static CompletableFuture<Suggestions> listSuggestions(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        String s = builder.getRemaining().toLowerCase(Locale.ROOT);
        Stream.of(BenchmarkManager.BenchmarkSize.values()).filter(e -> e.toString().toLowerCase(Locale.ROOT).startsWith(s)).forEach(e -> builder.suggest(e.toString(), (Message)e.createSuggestion()));
        return builder.buildFuture();
    }

    private static void info(CommandWrapper source) {
        source.sendFeedBackMessage((Component)TextUtil.translate("command.chunk_pregen.benchmark.info"));
    }

    private static void runSingleBenchmark(CommandWrapper source) {
        if (BenchmarkManager.INSTANCE.isBenchmarkRunning()) {
            source.sendErrorMessage((Component)TextUtil.translate("command.chunk_pregen.benchmark.active"));
            return;
        }
        if (source.getSenderId() == null) {
            source.sendErrorMessage((Component)TextUtil.translate("command.chunk_pregen.benchmark.player"));
            return;
        }
        ResourceKey<Level> dimension = source.getDimension("Dimension");
        if (ServerLifecycleHooks.getCurrentServer().getLevel(dimension) == null) {
            source.sendErrorMessage((Component)TextUtil.dimensionMissing());
            return;
        }
        boolean small = source.hasValue("Task-Size", BenchmarkManager.BenchmarkSize.class) ? source.getOrDefault("Task-Size", BenchmarkManager.BenchmarkSize.class, BenchmarkManager.BenchmarkSize.SMALL_TASK).isSmall() : source.getOrDefault("Small Task", Boolean.TYPE, true).booleanValue();
        ServerManager.INSTANCE.startTask(new BenchmarkTask("SingleBenchmarkTest", dimension, small), source.getSenderId(), source);
        BenchmarkManager.INSTANCE.startBenchmark(source.getSenderId());
    }

    private static void runBenchmark(CommandWrapper source) {
        if (BenchmarkManager.INSTANCE.isBenchmarkRunning()) {
            source.sendErrorMessage((Component)TextUtil.translate("command.chunk_pregen.benchmark.active"));
            return;
        }
        if (source.getSenderId() == null) {
            source.sendErrorMessage((Component)TextUtil.translate("command.chunk_pregen.benchmark.player"));
            return;
        }
        boolean small = source.hasValue("Task-Size", BenchmarkManager.BenchmarkSize.class) ? source.getOrDefault("Task-Size", BenchmarkManager.BenchmarkSize.class, BenchmarkManager.BenchmarkSize.SMALL_TASK).isSmall() : source.getOrDefault("Small Task", Boolean.TYPE, true).booleanValue();
        int index = 0;
        for (ResourceKey type : ServerLifecycleHooks.getCurrentServer().levelKeys()) {
            ServerManager.INSTANCE.startTask(new BenchmarkTask("BenchmarkTest_" + index, (ResourceKey<Level>)type, small), source.getSenderId(), source);
            ++index;
        }
        BenchmarkManager.INSTANCE.startBenchmark(source.getSenderId());
    }
}

